/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.api.model.TagReferenceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TagReferenceBuilder
extends TagReferenceFluentImpl<TagReferenceBuilder>
implements VisitableBuilder<TagReference, TagReferenceBuilder> {
    TagReferenceFluent<?> fluent;

    public TagReferenceBuilder() {
        this(new TagReference());
    }

    public TagReferenceBuilder(TagReferenceFluent<?> fluent) {
        this(fluent, new TagReference());
    }

    public TagReferenceBuilder(TagReferenceFluent<?> fluent, TagReference instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withFrom(instance.getFrom());
        fluent.withGeneration(instance.getGeneration());
        fluent.withImportPolicy(instance.getImportPolicy());
        fluent.withName(instance.getName());
        fluent.withReference(instance.getReference());
    }

    public TagReferenceBuilder(TagReference instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withFrom(instance.getFrom());
        this.withGeneration(instance.getGeneration());
        this.withImportPolicy(instance.getImportPolicy());
        this.withName(instance.getName());
        this.withReference(instance.getReference());
    }

    public TagReference build() {
        TagReference buildable = new TagReference(this.fluent.getAnnotations(), this.fluent.getFrom(), this.fluent.getGeneration(), this.fluent.getImportPolicy(), this.fluent.getName(), this.fluent.isReference());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagReferenceBuilder that = (TagReferenceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

