/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableRollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluent;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RollbackConfigBuilder
extends RollbackConfigFluentImpl<RollbackConfigBuilder>
implements VisitableBuilder<RollbackConfig, RollbackConfigBuilder> {
    RollbackConfigFluent<?> fluent;

    public RollbackConfigBuilder() {
        this(new RollbackConfig());
    }

    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent) {
        this(fluent, new RollbackConfig());
    }

    public RollbackConfigBuilder(RollbackConfigFluent<?> fluent, RollbackConfig instance) {
        this.fluent = fluent;
        fluent.withRevision(instance.getRevision());
    }

    public RollbackConfigBuilder(RollbackConfig instance) {
        this.fluent = this;
        this.withRevision(instance.getRevision());
    }

    public EditableRollbackConfig build() {
        EditableRollbackConfig buildable = new EditableRollbackConfig(this.fluent.getRevision());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RollbackConfigBuilder that = (RollbackConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

