/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.EditableJobStatus;
import io.fabric8.kubernetes.api.model.extensions.JobStatus;
import io.fabric8.kubernetes.api.model.extensions.JobStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.JobStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class JobStatusBuilder
extends JobStatusFluentImpl<JobStatusBuilder>
implements VisitableBuilder<JobStatus, JobStatusBuilder> {
    JobStatusFluent<?> fluent;

    public JobStatusBuilder() {
        this(new JobStatus());
    }

    public JobStatusBuilder(JobStatusFluent<?> fluent) {
        this(fluent, new JobStatus());
    }

    public JobStatusBuilder(JobStatusFluent<?> fluent, JobStatus instance) {
        this.fluent = fluent;
        fluent.withActive(instance.getActive());
        fluent.withCompletionTime(instance.getCompletionTime());
        fluent.withConditions(instance.getConditions());
        fluent.withFailed(instance.getFailed());
        fluent.withStartTime(instance.getStartTime());
        fluent.withSucceeded(instance.getSucceeded());
    }

    public JobStatusBuilder(JobStatus instance) {
        this.fluent = this;
        this.withActive(instance.getActive());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
    }

    public EditableJobStatus build() {
        EditableJobStatus buildable = new EditableJobStatus(this.fluent.getActive(), this.fluent.getCompletionTime(), this.fluent.getConditions(), this.fluent.getFailed(), this.fluent.getStartTime(), this.fluent.getSucceeded());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusBuilder that = (JobStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

