/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceAccountFluent<T extends ServiceAccountFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ServiceAccount.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    List<VisitableBuilder<ObjectReference, ?>> secrets = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ServiceAccount.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ServiceAccount.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public T addToSecrets(ObjectReference item) {
        if (item != null) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (T)((Object)this);
    }

    public List<ObjectReference> getSecrets() {
        return this.build(this.secrets);
    }

    public T withSecrets(List<ObjectReference> secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (T)((Object)this);
    }

    public SecretsNested<T> addNewSecret() {
        return new SecretsNested();
    }

    public SecretsNested<T> addNewSecretLike(ObjectReference item) {
        return new SecretsNested(item);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class SecretsNested<N>
    extends ObjectReferenceFluent<SecretsNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        SecretsNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SecretsNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        public N and() {
            return (N)ServiceAccountFluent.this.addToSecrets(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)ServiceAccountFluent.this.withMetadata(this.builder.build());
        }
    }
}

