/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.config;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fabric8.kubernetes.api.model.config.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.config.NamedCluster;
import io.fabric8.kubernetes.api.model.config.NamedContext;
import io.fabric8.kubernetes.api.model.config.NamedExtension;
import io.fabric8.kubernetes.api.model.config.Preferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "clusters", "contexts", "current-context", "extensions", "kind", "preferences", "users"})
public class Config {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta3");
    @JsonProperty(value="clusters")
    @Valid
    private List<NamedCluster> clusters = new ArrayList<NamedCluster>();
    @JsonProperty(value="contexts")
    @Valid
    private List<NamedContext> contexts = new ArrayList<NamedContext>();
    @JsonProperty(value="current-context")
    private String currentContext;
    @JsonProperty(value="extensions")
    @Valid
    private List<NamedExtension> extensions = new ArrayList<NamedExtension>();
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Config";
    @JsonProperty(value="preferences")
    @Valid
    private Preferences preferences;
    @JsonProperty(value="users")
    @Valid
    private List<NamedAuthInfo> users = new ArrayList<NamedAuthInfo>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Config() {
    }

    public Config(ApiVersion apiVersion, List<NamedCluster> clusters, List<NamedContext> contexts, String currentContext, List<NamedExtension> extensions, String kind, Preferences preferences, List<NamedAuthInfo> users) {
        this.apiVersion = apiVersion;
        this.clusters = clusters;
        this.contexts = contexts;
        this.currentContext = currentContext;
        this.extensions = extensions;
        this.kind = kind;
        this.preferences = preferences;
        this.users = users;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="clusters")
    public List<NamedCluster> getClusters() {
        return this.clusters;
    }

    @JsonProperty(value="clusters")
    public void setClusters(List<NamedCluster> clusters) {
        this.clusters = clusters;
    }

    @JsonProperty(value="contexts")
    public List<NamedContext> getContexts() {
        return this.contexts;
    }

    @JsonProperty(value="contexts")
    public void setContexts(List<NamedContext> contexts) {
        this.contexts = contexts;
    }

    @JsonProperty(value="current-context")
    public String getCurrentContext() {
        return this.currentContext;
    }

    @JsonProperty(value="current-context")
    public void setCurrentContext(String currentContext) {
        this.currentContext = currentContext;
    }

    @JsonProperty(value="extensions")
    public List<NamedExtension> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<NamedExtension> extensions) {
        this.extensions = extensions;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="preferences")
    public Preferences getPreferences() {
        return this.preferences;
    }

    @JsonProperty(value="preferences")
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @JsonProperty(value="users")
    public List<NamedAuthInfo> getUsers() {
        return this.users;
    }

    @JsonProperty(value="users")
    public void setUsers(List<NamedAuthInfo> users) {
        this.users = users;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.apiVersion).append(this.clusters).append(this.contexts).append((Object)this.currentContext).append(this.extensions).append((Object)this.kind).append((Object)this.preferences).append(this.users).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Config)) {
            return false;
        }
        Config rhs = (Config)other;
        return new EqualsBuilder().append((Object)this.apiVersion, (Object)rhs.apiVersion).append(this.clusters, rhs.clusters).append(this.contexts, rhs.contexts).append((Object)this.currentContext, (Object)rhs.currentContext).append(this.extensions, rhs.extensions).append((Object)this.kind, (Object)rhs.kind).append((Object)this.preferences, (Object)rhs.preferences).append(this.users, rhs.users).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_1("v1beta1"),
        V_1_BETA_2("v1beta2"),
        V_1_BETA_3("v1beta3"),
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

