/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodSpecFluent<T extends PodSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
    String dnsPolicy;
    String host;
    Boolean hostNetwork;
    Map<String, String> nodeSelector = new HashMap<String, String>();
    String restartPolicy;
    Long terminationGracePeriodSeconds;
    List<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToContainers(Container item) {
        if (item != null) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.add(builder);
            this.containers.add(builder);
        }
        return (T)((Object)this);
    }

    public List<Container> getContainers() {
        return this.build(this.containers);
    }

    public T withContainers(List<Container> containers) {
        this.containers.clear();
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (T)((Object)this);
    }

    public ContainersNested<T> addNewContainer() {
        return new ContainersNested();
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public T withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (T)((Object)this);
    }

    public String getHost() {
        return this.host;
    }

    public T withHost(String host) {
        this.host = host;
        return (T)((Object)this);
    }

    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    public T withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (T)((Object)this);
    }

    public T addToNodeSelector(String key, String value) {
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public T withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector.clear();
        if (nodeSelector != null) {
            this.nodeSelector.putAll(nodeSelector);
        }
        return (T)((Object)this);
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public T withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (T)((Object)this);
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public T withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (T)((Object)this);
    }

    public T addToVolumes(Volume item) {
        if (item != null) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.add(builder);
            this.volumes.add(builder);
        }
        return (T)((Object)this);
    }

    public List<Volume> getVolumes() {
        return this.build(this.volumes);
    }

    public T withVolumes(List<Volume> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (T)((Object)this);
    }

    public VolumesNested<T> addNewVolume() {
        return new VolumesNested();
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        private final VolumeBuilder builder = new VolumeBuilder(this);

        public N and() {
            return (N)PodSpecFluent.this.addToVolumes(this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        private final ContainerBuilder builder = new ContainerBuilder(this);

        public N and() {
            return (N)PodSpecFluent.this.addToContainers(this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

