/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.NamespaceStatus;
import io.fabric8.kubernetes.api.model.NamespaceStatusFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamespaceStatusBuilder
extends NamespaceStatusFluent<NamespaceStatusBuilder>
implements Builder<NamespaceStatus> {
    NamespaceStatusFluent<?> fluent;

    public NamespaceStatusBuilder() {
        this(new NamespaceStatus());
    }

    public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent) {
        this(fluent, new NamespaceStatus());
    }

    public NamespaceStatusBuilder(NamespaceStatusFluent<?> fluent, NamespaceStatus instance) {
        this.fluent = fluent;
        fluent.withPhase(instance.getPhase());
    }

    public NamespaceStatusBuilder(NamespaceStatus instance) {
        this.fluent = this;
        this.withPhase(instance.getPhase());
    }

    public NamespaceStatus build() {
        NamespaceStatus buildable = new NamespaceStatus(this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

