/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.BaseFluent;
import io.fabric8.common.Fluent;
import io.fabric8.common.Nested;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceSpecFluent<T extends ServiceSpecFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Boolean createExternalLoadBalancer;
    String portalIP;
    List<ServicePortBuilder> ports = new ArrayList<ServicePortBuilder>();
    List<String> publicIPs = new ArrayList<String>();
    Map<String, String> selector = new HashMap<String, String>();
    String sessionAffinity;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Boolean isCreateExternalLoadBalancer() {
        return this.createExternalLoadBalancer;
    }

    public T withCreateExternalLoadBalancer(Boolean createExternalLoadBalancer) {
        this.createExternalLoadBalancer = createExternalLoadBalancer;
        return (T)((Object)this);
    }

    public String getPortalIP() {
        return this.portalIP;
    }

    public T withPortalIP(String portalIP) {
        this.portalIP = portalIP;
        return (T)((Object)this);
    }

    public T addToPorts(ServicePort item) {
        if (item != null) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)((Object)this);
    }

    public List<ServicePort> getPorts() {
        return this.build(this.ports);
    }

    public T withPorts(List<ServicePort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)((Object)this);
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public T addToPublicIPs(String item) {
        if (item != null) {
            this.publicIPs.add(item);
        }
        return (T)((Object)this);
    }

    public List<String> getPublicIPs() {
        return this.publicIPs;
    }

    public T withPublicIPs(List<String> publicIPs) {
        this.publicIPs.clear();
        if (publicIPs != null) {
            for (String item : publicIPs) {
                this.addToPublicIPs(item);
            }
        }
        return (T)((Object)this);
    }

    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)((Object)this);
    }

    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public T withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class PortsNested<N>
    extends ServicePortFluent<PortsNested<N>>
    implements Nested<N> {
        private final ServicePortBuilder builder = new ServicePortBuilder(this);

        public N and() {
            return (N)ServiceSpecFluent.this.addToPorts(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

