/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.VolumeSource;
import io.fabric8.kubernetes.api.model.VolumeSourceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeSourceBuilder
extends VolumeSourceFluent<VolumeSourceBuilder>
implements Builder<VolumeSource> {
    private final VolumeSourceFluent<?> fluent;

    public VolumeSourceBuilder() {
        this(new VolumeSource());
    }

    public VolumeSourceBuilder(VolumeSourceFluent<?> fluent) {
        this(fluent, new VolumeSource());
    }

    public VolumeSourceBuilder(VolumeSourceFluent<?> fluent, VolumeSource instance) {
        this.fluent = fluent;
        fluent.withEmptyDir(instance.getEmptyDir());
        fluent.withGitRepo(instance.getGitRepo());
        fluent.withGlusterfs(instance.getGlusterfs());
        fluent.withHostDir(instance.getHostDir());
        fluent.withIscsi(instance.getIscsi());
        fluent.withNfs(instance.getNfs());
        fluent.withPersistentDisk(instance.getPersistentDisk());
        fluent.withSecret(instance.getSecret());
    }

    public VolumeSourceBuilder(VolumeSource instance) {
        this.fluent = this;
        this.withEmptyDir(instance.getEmptyDir());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostDir(instance.getHostDir());
        this.withIscsi(instance.getIscsi());
        this.withNfs(instance.getNfs());
        this.withPersistentDisk(instance.getPersistentDisk());
        this.withSecret(instance.getSecret());
    }

    public VolumeSource build() {
        VolumeSource buildable = new VolumeSource(this.fluent.getEmptyDir(), this.fluent.getGitRepo(), this.fluent.getGlusterfs(), this.fluent.getHostDir(), this.fluent.getIscsi(), this.fluent.getNfs(), this.fluent.getPersistentDisk(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

