/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.util.IntOrString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "apiVersion", "containerPort", "createExternalLoadBalancer", "creationTimestamp", "deletionTimestamp", "generateName", "id", "kind", "labels", "namespace", "port", "portName", "portalIP", "ports", "protocol", "proxyPort", "publicIPs", "resourceVersion", "selector", "selfLink", "sessionAffinity", "uid"})
public class Service {
    @JsonProperty(value="annotations")
    @Valid
    private Map<String, String> annotations;
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta2");
    @JsonProperty(value="containerPort")
    @Valid
    private IntOrString containerPort;
    @JsonProperty(value="createExternalLoadBalancer")
    private Boolean createExternalLoadBalancer;
    @JsonProperty(value="creationTimestamp")
    private String creationTimestamp;
    @JsonProperty(value="deletionTimestamp")
    private String deletionTimestamp;
    @JsonProperty(value="generateName")
    private String generateName;
    @JsonProperty(value="id")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String id;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Service";
    @JsonProperty(value="labels")
    @Valid
    private Map<String, String> labels;
    @JsonProperty(value="namespace")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String namespace;
    @JsonProperty(value="port")
    private Integer port;
    @JsonProperty(value="portName")
    private String portName;
    @JsonProperty(value="portalIP")
    private String portalIP;
    @JsonProperty(value="ports")
    @Valid
    private List<ServicePort> ports = new ArrayList<ServicePort>();
    @JsonProperty(value="protocol")
    private String protocol;
    @JsonProperty(value="proxyPort")
    private Integer proxyPort;
    @JsonProperty(value="publicIPs")
    @Valid
    private List<String> publicIPs = new ArrayList<String>();
    @JsonProperty(value="resourceVersion")
    private Integer resourceVersion;
    @JsonProperty(value="selector")
    @Valid
    private Map<String, String> selector;
    @JsonProperty(value="selfLink")
    private String selfLink;
    @JsonProperty(value="sessionAffinity")
    private String sessionAffinity;
    @JsonProperty(value="uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Service() {
    }

    public Service(Map<String, String> annotations, ApiVersion apiVersion, IntOrString containerPort, Boolean createExternalLoadBalancer, String creationTimestamp, String deletionTimestamp, String generateName, String id, String kind, Map<String, String> labels, String namespace, Integer port, String portName, String portalIP, List<ServicePort> ports, String protocol, Integer proxyPort, List<String> publicIPs, Integer resourceVersion, Map<String, String> selector, String selfLink, String sessionAffinity, String uid) {
        this.annotations = annotations;
        this.apiVersion = apiVersion;
        this.containerPort = containerPort;
        this.createExternalLoadBalancer = createExternalLoadBalancer;
        this.creationTimestamp = creationTimestamp;
        this.deletionTimestamp = deletionTimestamp;
        this.generateName = generateName;
        this.id = id;
        this.kind = kind;
        this.labels = labels;
        this.namespace = namespace;
        this.port = port;
        this.portName = portName;
        this.portalIP = portalIP;
        this.ports = ports;
        this.protocol = protocol;
        this.proxyPort = proxyPort;
        this.publicIPs = publicIPs;
        this.resourceVersion = resourceVersion;
        this.selector = selector;
        this.selfLink = selfLink;
        this.sessionAffinity = sessionAffinity;
        this.uid = uid;
    }

    @JsonProperty(value="annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="containerPort")
    public IntOrString getContainerPort() {
        return this.containerPort;
    }

    @JsonProperty(value="containerPort")
    public void setContainerPort(IntOrString containerPort) {
        this.containerPort = containerPort;
    }

    @JsonProperty(value="createExternalLoadBalancer")
    public Boolean getCreateExternalLoadBalancer() {
        return this.createExternalLoadBalancer;
    }

    @JsonProperty(value="createExternalLoadBalancer")
    public void setCreateExternalLoadBalancer(Boolean createExternalLoadBalancer) {
        this.createExternalLoadBalancer = createExternalLoadBalancer;
    }

    @JsonProperty(value="creationTimestamp")
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @JsonProperty(value="creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public void setDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    @JsonProperty(value="generateName")
    public String getGenerateName() {
        return this.generateName;
    }

    @JsonProperty(value="generateName")
    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="labels")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    public void setPort(Integer port) {
        this.port = port;
    }

    @JsonProperty(value="portName")
    public String getPortName() {
        return this.portName;
    }

    @JsonProperty(value="portName")
    public void setPortName(String portName) {
        this.portName = portName;
    }

    @JsonProperty(value="portalIP")
    public String getPortalIP() {
        return this.portalIP;
    }

    @JsonProperty(value="portalIP")
    public void setPortalIP(String portalIP) {
        this.portalIP = portalIP;
    }

    @JsonProperty(value="ports")
    public List<ServicePort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="ports")
    public void setPorts(List<ServicePort> ports) {
        this.ports = ports;
    }

    @JsonProperty(value="protocol")
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="proxyPort")
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @JsonProperty(value="proxyPort")
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @JsonProperty(value="publicIPs")
    public List<String> getPublicIPs() {
        return this.publicIPs;
    }

    @JsonProperty(value="publicIPs")
    public void setPublicIPs(List<String> publicIPs) {
        this.publicIPs = publicIPs;
    }

    @JsonProperty(value="resourceVersion")
    public Integer getResourceVersion() {
        return this.resourceVersion;
    }

    @JsonProperty(value="resourceVersion")
    public void setResourceVersion(Integer resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @JsonProperty(value="selector")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @JsonProperty(value="selector")
    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    @JsonProperty(value="selfLink")
    public String getSelfLink() {
        return this.selfLink;
    }

    @JsonProperty(value="selfLink")
    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    @JsonProperty(value="sessionAffinity")
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @JsonProperty(value="sessionAffinity")
    public void setSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.annotations).append((Object)this.apiVersion).append((Object)this.containerPort).append((Object)this.createExternalLoadBalancer).append((Object)this.creationTimestamp).append((Object)this.deletionTimestamp).append((Object)this.generateName).append((Object)this.id).append((Object)this.kind).append(this.labels).append((Object)this.namespace).append((Object)this.port).append((Object)this.portName).append((Object)this.portalIP).append(this.ports).append((Object)this.protocol).append((Object)this.proxyPort).append(this.publicIPs).append((Object)this.resourceVersion).append(this.selector).append((Object)this.selfLink).append((Object)this.sessionAffinity).append((Object)this.uid).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Service)) {
            return false;
        }
        Service rhs = (Service)other;
        return new EqualsBuilder().append(this.annotations, rhs.annotations).append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.containerPort, (Object)rhs.containerPort).append((Object)this.createExternalLoadBalancer, (Object)rhs.createExternalLoadBalancer).append((Object)this.creationTimestamp, (Object)rhs.creationTimestamp).append((Object)this.deletionTimestamp, (Object)rhs.deletionTimestamp).append((Object)this.generateName, (Object)rhs.generateName).append((Object)this.id, (Object)rhs.id).append((Object)this.kind, (Object)rhs.kind).append(this.labels, rhs.labels).append((Object)this.namespace, (Object)rhs.namespace).append((Object)this.port, (Object)rhs.port).append((Object)this.portName, (Object)rhs.portName).append((Object)this.portalIP, (Object)rhs.portalIP).append(this.ports, rhs.ports).append((Object)this.protocol, (Object)rhs.protocol).append((Object)this.proxyPort, (Object)rhs.proxyPort).append(this.publicIPs, rhs.publicIPs).append((Object)this.resourceVersion, (Object)rhs.resourceVersion).append(this.selector, rhs.selector).append((Object)this.selfLink, (Object)rhs.selfLink).append((Object)this.sessionAffinity, (Object)rhs.sessionAffinity).append((Object)this.uid, (Object)rhs.uid).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_1("v1beta1"),
        V_1_BETA_2("v1beta2"),
        V_1_BETA_3("v1beta3");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

