/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeConditionBuilder
extends NodeConditionFluent<NodeConditionBuilder>
implements Builder<NodeCondition> {
    private final NodeConditionFluent<?> fluent;

    public NodeConditionBuilder() {
        this(new NodeCondition());
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent) {
        this(fluent, new NodeCondition());
    }

    public NodeConditionBuilder(NodeConditionFluent<?> fluent, NodeCondition instance) {
        this.fluent = fluent;
        fluent.withKind(instance.getKind());
        fluent.withLastProbeTime(instance.getLastProbeTime());
        fluent.withLastTransitionTime(instance.getLastTransitionTime());
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        fluent.withStatus(instance.getStatus());
    }

    public NodeConditionBuilder(NodeCondition instance) {
        this.fluent = this;
        this.withKind(instance.getKind());
        this.withLastProbeTime(instance.getLastProbeTime());
        this.withLastTransitionTime(instance.getLastTransitionTime());
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.withStatus(instance.getStatus());
    }

    public NodeCondition build() {
        NodeCondition buildable = new NodeCondition(this.fluent.getKind(), this.fluent.getLastProbeTime(), this.fluent.getLastTransitionTime(), this.fluent.getMessage(), this.fluent.getReason(), this.fluent.getStatus());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

