/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.fabric8.kubernetes.api.model.NodeResources;
import io.fabric8.kubernetes.api.model.NodeStatus;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "apiVersion", "creationTimestamp", "deletionTimestamp", "externalID", "generateName", "hostIP", "id", "kind", "labels", "namespace", "podCIDR", "resourceVersion", "resources", "selfLink", "status", "uid", "unschedulable"})
public class Minion {
    @JsonProperty(value="annotations")
    @Valid
    private Map<String, String> annotations;
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1beta2");
    @JsonProperty(value="creationTimestamp")
    private String creationTimestamp;
    @JsonProperty(value="deletionTimestamp")
    private String deletionTimestamp;
    @JsonProperty(value="externalID")
    private String externalID;
    @JsonProperty(value="generateName")
    private String generateName;
    @JsonProperty(value="hostIP")
    private String hostIP;
    @JsonProperty(value="id")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String id;
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "Minion";
    @JsonProperty(value="labels")
    @Valid
    private Map<String, String> labels;
    @JsonProperty(value="namespace")
    @Pattern(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$")
    @Size(max=253)
    private String namespace;
    @JsonProperty(value="podCIDR")
    private String podCIDR;
    @JsonProperty(value="resourceVersion")
    private Integer resourceVersion;
    @JsonProperty(value="resources")
    @Valid
    private NodeResources resources;
    @JsonProperty(value="selfLink")
    private String selfLink;
    @JsonProperty(value="status")
    @Valid
    private NodeStatus status;
    @JsonProperty(value="uid")
    private String uid;
    @JsonProperty(value="unschedulable")
    private Boolean unschedulable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Minion() {
    }

    public Minion(Map<String, String> annotations, ApiVersion apiVersion, String creationTimestamp, String deletionTimestamp, String externalID, String generateName, String hostIP, String id, String kind, Map<String, String> labels, String namespace, String podCIDR, Integer resourceVersion, NodeResources resources, String selfLink, NodeStatus status, String uid, Boolean unschedulable) {
        this.annotations = annotations;
        this.apiVersion = apiVersion;
        this.creationTimestamp = creationTimestamp;
        this.deletionTimestamp = deletionTimestamp;
        this.externalID = externalID;
        this.generateName = generateName;
        this.hostIP = hostIP;
        this.id = id;
        this.kind = kind;
        this.labels = labels;
        this.namespace = namespace;
        this.podCIDR = podCIDR;
        this.resourceVersion = resourceVersion;
        this.resources = resources;
        this.selfLink = selfLink;
        this.status = status;
        this.uid = uid;
        this.unschedulable = unschedulable;
    }

    @JsonProperty(value="annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="creationTimestamp")
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @JsonProperty(value="creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @JsonProperty(value="deletionTimestamp")
    public void setDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
    }

    @JsonProperty(value="externalID")
    public String getExternalID() {
        return this.externalID;
    }

    @JsonProperty(value="externalID")
    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    @JsonProperty(value="generateName")
    public String getGenerateName() {
        return this.generateName;
    }

    @JsonProperty(value="generateName")
    public void setGenerateName(String generateName) {
        this.generateName = generateName;
    }

    @JsonProperty(value="hostIP")
    public String getHostIP() {
        return this.hostIP;
    }

    @JsonProperty(value="hostIP")
    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="labels")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="podCIDR")
    public String getPodCIDR() {
        return this.podCIDR;
    }

    @JsonProperty(value="podCIDR")
    public void setPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
    }

    @JsonProperty(value="resourceVersion")
    public Integer getResourceVersion() {
        return this.resourceVersion;
    }

    @JsonProperty(value="resourceVersion")
    public void setResourceVersion(Integer resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @JsonProperty(value="resources")
    public NodeResources getResources() {
        return this.resources;
    }

    @JsonProperty(value="resources")
    public void setResources(NodeResources resources) {
        this.resources = resources;
    }

    @JsonProperty(value="selfLink")
    public String getSelfLink() {
        return this.selfLink;
    }

    @JsonProperty(value="selfLink")
    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    @JsonProperty(value="status")
    public NodeStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(NodeStatus status) {
        this.status = status;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="unschedulable")
    public Boolean getUnschedulable() {
        return this.unschedulable;
    }

    @JsonProperty(value="unschedulable")
    public void setUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.annotations).append((Object)this.apiVersion).append((Object)this.creationTimestamp).append((Object)this.deletionTimestamp).append((Object)this.externalID).append((Object)this.generateName).append((Object)this.hostIP).append((Object)this.id).append((Object)this.kind).append(this.labels).append((Object)this.namespace).append((Object)this.podCIDR).append((Object)this.resourceVersion).append((Object)this.resources).append((Object)this.selfLink).append((Object)this.status).append((Object)this.uid).append((Object)this.unschedulable).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Minion)) {
            return false;
        }
        Minion rhs = (Minion)other;
        return new EqualsBuilder().append(this.annotations, rhs.annotations).append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.creationTimestamp, (Object)rhs.creationTimestamp).append((Object)this.deletionTimestamp, (Object)rhs.deletionTimestamp).append((Object)this.externalID, (Object)rhs.externalID).append((Object)this.generateName, (Object)rhs.generateName).append((Object)this.hostIP, (Object)rhs.hostIP).append((Object)this.id, (Object)rhs.id).append((Object)this.kind, (Object)rhs.kind).append(this.labels, rhs.labels).append((Object)this.namespace, (Object)rhs.namespace).append((Object)this.podCIDR, (Object)rhs.podCIDR).append((Object)this.resourceVersion, (Object)rhs.resourceVersion).append((Object)this.resources, (Object)rhs.resources).append((Object)this.selfLink, (Object)rhs.selfLink).append((Object)this.status, (Object)rhs.status).append((Object)this.uid, (Object)rhs.uid).append((Object)this.unschedulable, (Object)rhs.unschedulable).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum ApiVersion {
        V_1_BETA_1("v1beta1"),
        V_1_BETA_2("v1beta2"),
        V_1_BETA_3("v1beta3");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

