/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.KubeSchema;
import io.fabric8.kubernetes.api.model.KubeSchemaFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class KubeSchemaBuilder
extends KubeSchemaFluent<KubeSchemaBuilder>
implements Builder<KubeSchema> {
    private final KubeSchemaFluent<?> fluent;

    public KubeSchemaBuilder() {
        this(new KubeSchema());
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent) {
        this(fluent, new KubeSchema());
    }

    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent, KubeSchema instance) {
        this.fluent = fluent;
        fluent.withBuildConfigList(instance.getBuildConfigList());
        fluent.withBuildList(instance.getBuildList());
        fluent.withConfig(instance.getConfig());
        fluent.withContainerStatus(instance.getContainerStatus());
        fluent.withDeploymentConfigList(instance.getDeploymentConfigList());
        fluent.withDeploymentList(instance.getDeploymentList());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withEndpointsList(instance.getEndpointsList());
        fluent.withEnvVar(instance.getEnvVar());
        fluent.withImageList(instance.getImageList());
        fluent.withImageRepositoryList(instance.getImageRepositoryList());
        fluent.withKubernetesList(instance.getKubernetesList());
        fluent.withMinion(instance.getMinion());
        fluent.withMinionList(instance.getMinionList());
        fluent.withPodList(instance.getPodList());
        fluent.withQuantity(instance.getQuantity());
        fluent.withReplicationControllerList(instance.getReplicationControllerList());
        fluent.withRouteList(instance.getRouteList());
        fluent.withServiceList(instance.getServiceList());
        fluent.withStatusError(instance.getStatusError());
        fluent.withTagEvent(instance.getTagEvent());
        fluent.withTagEventList(instance.getTagEventList());
        fluent.withTemplate(instance.getTemplate());
    }

    public KubeSchemaBuilder(KubeSchema instance) {
        this.fluent = this;
        this.withBuildConfigList(instance.getBuildConfigList());
        this.withBuildList(instance.getBuildList());
        this.withConfig(instance.getConfig());
        this.withContainerStatus(instance.getContainerStatus());
        this.withDeploymentConfigList(instance.getDeploymentConfigList());
        this.withDeploymentList(instance.getDeploymentList());
        this.withEndpoints(instance.getEndpoints());
        this.withEndpointsList(instance.getEndpointsList());
        this.withEnvVar(instance.getEnvVar());
        this.withImageList(instance.getImageList());
        this.withImageRepositoryList(instance.getImageRepositoryList());
        this.withKubernetesList(instance.getKubernetesList());
        this.withMinion(instance.getMinion());
        this.withMinionList(instance.getMinionList());
        this.withPodList(instance.getPodList());
        this.withQuantity(instance.getQuantity());
        this.withReplicationControllerList(instance.getReplicationControllerList());
        this.withRouteList(instance.getRouteList());
        this.withServiceList(instance.getServiceList());
        this.withStatusError(instance.getStatusError());
        this.withTagEvent(instance.getTagEvent());
        this.withTagEventList(instance.getTagEventList());
        this.withTemplate(instance.getTemplate());
    }

    public KubeSchema build() {
        KubeSchema buildable = new KubeSchema(this.fluent.getBuildConfigList(), this.fluent.getBuildList(), this.fluent.getConfig(), this.fluent.getContainerStatus(), this.fluent.getDeploymentConfigList(), this.fluent.getDeploymentList(), this.fluent.getEndpoints(), this.fluent.getEndpointsList(), this.fluent.getEnvVar(), this.fluent.getImageList(), this.fluent.getImageRepositoryList(), this.fluent.getKubernetesList(), this.fluent.getMinion(), this.fluent.getMinionList(), this.fluent.getPodList(), this.fluent.getQuantity(), this.fluent.getReplicationControllerList(), this.fluent.getRouteList(), this.fluent.getServiceList(), this.fluent.getStatusError(), this.fluent.getTagEvent(), this.fluent.getTagEventList(), this.fluent.getTemplate());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

