/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class EndpointsBuilder
extends EndpointsFluent<EndpointsBuilder>
implements Builder<Endpoints> {
    private final EndpointsFluent<?> fluent;

    public EndpointsBuilder() {
        this(new Endpoints());
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent) {
        this(fluent, new Endpoints());
    }

    public EndpointsBuilder(EndpointsFluent<?> fluent, Endpoints instance) {
        this.fluent = fluent;
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCreationTimestamp(instance.getCreationTimestamp());
        fluent.withDeletionTimestamp(instance.getDeletionTimestamp());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withGenerateName(instance.getGenerateName());
        fluent.withId(instance.getId());
        fluent.withKind(instance.getKind());
        fluent.withNamespace(instance.getNamespace());
        fluent.withProtocol(instance.getProtocol());
        fluent.withResourceVersion(instance.getResourceVersion());
        fluent.withSelfLink(instance.getSelfLink());
        fluent.withSubsets(instance.getSubsets());
        fluent.withTargetRefs(instance.getTargetRefs());
        fluent.withUid(instance.getUid());
    }

    public EndpointsBuilder(Endpoints instance) {
        this.fluent = this;
        this.withAnnotations(instance.getAnnotations());
        this.withApiVersion(instance.getApiVersion());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withEndpoints(instance.getEndpoints());
        this.withGenerateName(instance.getGenerateName());
        this.withId(instance.getId());
        this.withKind(instance.getKind());
        this.withNamespace(instance.getNamespace());
        this.withProtocol(instance.getProtocol());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withSubsets(instance.getSubsets());
        this.withTargetRefs(instance.getTargetRefs());
        this.withUid(instance.getUid());
    }

    public Endpoints build() {
        Endpoints buildable = new Endpoints(this.fluent.getAnnotations(), this.fluent.getApiVersion(), this.fluent.getCreationTimestamp(), this.fluent.getDeletionTimestamp(), this.fluent.getEndpoints(), this.fluent.getGenerateName(), this.fluent.getId(), this.fluent.getKind(), this.fluent.getNamespace(), this.fluent.getProtocol(), this.fluent.getResourceVersion(), this.fluent.getSelfLink(), this.fluent.getSubsets(), this.fluent.getTargetRefs(), this.fluent.getUid());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

