/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateWaitingBuilder
extends ContainerStateWaitingFluent<ContainerStateWaitingBuilder>
implements Builder<ContainerStateWaiting> {
    private final ContainerStateWaitingFluent<?> fluent;

    public ContainerStateWaitingBuilder() {
        this(new ContainerStateWaiting());
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent) {
        this(fluent, new ContainerStateWaiting());
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent, ContainerStateWaiting instance) {
        this.fluent = fluent;
        fluent.withReason(instance.getReason());
    }

    public ContainerStateWaitingBuilder(ContainerStateWaiting instance) {
        this.fluent = this;
        this.withReason(instance.getReason());
    }

    public ContainerStateWaiting build() {
        ContainerStateWaiting buildable = new ContainerStateWaiting(this.fluent.getReason());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

