/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.util.IntOrString;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractServiceFluentAssert<S extends AbstractServiceFluentAssert<S, A>, A extends ServiceFluent>
extends AbstractAssert<S, A> {
    protected AbstractServiceFluentAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ServiceFluent)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasAnnotations(Map annotations) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected annotations of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualAnnotations = ((ServiceFluent)this.actual).getAnnotations();
        if (!Objects.areEqual(actualAnnotations, (Object)annotations)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, annotations, actualAnnotations});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasApiVersion(Service.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Service.ApiVersion actualApiVersion = ((ServiceFluent)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasContainerPort(IntOrString containerPort) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected containerPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        IntOrString actualContainerPort = ((ServiceFluent)this.actual).getContainerPort();
        if (!Objects.areEqual((Object)actualContainerPort, (Object)containerPort)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, containerPort, actualContainerPort});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasCreationTimestamp(String creationTimestamp) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected creationTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCreationTimestamp = ((ServiceFluent)this.actual).getCreationTimestamp();
        if (!Objects.areEqual((Object)actualCreationTimestamp, (Object)creationTimestamp)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, creationTimestamp, actualCreationTimestamp});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasDeletionTimestamp(String deletionTimestamp) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected deletionTimestamp of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDeletionTimestamp = ((ServiceFluent)this.actual).getDeletionTimestamp();
        if (!Objects.areEqual((Object)actualDeletionTimestamp, (Object)deletionTimestamp)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, deletionTimestamp, actualDeletionTimestamp});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasGenerateName(String generateName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected generateName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualGenerateName = ((ServiceFluent)this.actual).getGenerateName();
        if (!Objects.areEqual((Object)actualGenerateName, (Object)generateName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, generateName, actualGenerateName});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((ServiceFluent)this.actual).getId();
        if (!Objects.areEqual((Object)actualId, (Object)id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((ServiceFluent)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasLabels(Map labels) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected labels of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualLabels = ((ServiceFluent)this.actual).getLabels();
        if (!Objects.areEqual(actualLabels, (Object)labels)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, labels, actualLabels});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasNamespace(String namespace) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected namespace of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualNamespace = ((ServiceFluent)this.actual).getNamespace();
        if (!Objects.areEqual((Object)actualNamespace, (Object)namespace)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, namespace, actualNamespace});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasPort(Integer port) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected port of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualPort = ((ServiceFluent)this.actual).getPort();
        if (!Objects.areEqual((Object)actualPort, (Object)port)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, port, actualPort});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasPortName(String portName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected portName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPortName = ((ServiceFluent)this.actual).getPortName();
        if (!Objects.areEqual((Object)actualPortName, (Object)portName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, portName, actualPortName});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasPortalIP(String portalIP) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected portalIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPortalIP = ((ServiceFluent)this.actual).getPortalIP();
        if (!Objects.areEqual((Object)actualPortalIP, (Object)portalIP)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, portalIP, actualPortalIP});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasPorts(ServicePort ... ports) {
        this.isNotNull();
        if (ports == null) {
            throw new AssertionError((Object)"Expecting ports parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceFluent)this.actual).getPorts(), (Object[])ports);
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasNoPorts() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have ports but had :\n  <%s>";
        if (((ServiceFluent)this.actual).getPorts().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceFluent)this.actual).getPorts()});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasProtocol(String protocol) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected protocol of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualProtocol = ((ServiceFluent)this.actual).getProtocol();
        if (!Objects.areEqual((Object)actualProtocol, (Object)protocol)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, protocol, actualProtocol});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasProxyPort(Integer proxyPort) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected proxyPort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualProxyPort = ((ServiceFluent)this.actual).getProxyPort();
        if (!Objects.areEqual((Object)actualProxyPort, (Object)proxyPort)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, proxyPort, actualProxyPort});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasPublicIPs(String ... publicIPs) {
        this.isNotNull();
        if (publicIPs == null) {
            throw new AssertionError((Object)"Expecting publicIPs parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceFluent)this.actual).getPublicIPs(), (Object[])publicIPs);
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasNoPublicIPs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have publicIPs but had :\n  <%s>";
        if (((ServiceFluent)this.actual).getPublicIPs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceFluent)this.actual).getPublicIPs()});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasResourceVersion(Integer resourceVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected resourceVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualResourceVersion = ((ServiceFluent)this.actual).getResourceVersion();
        if (!Objects.areEqual((Object)actualResourceVersion, (Object)resourceVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, resourceVersion, actualResourceVersion});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasSelector(Map selector) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualSelector = ((ServiceFluent)this.actual).getSelector();
        if (!Objects.areEqual(actualSelector, (Object)selector)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, selector, actualSelector});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasSelfLink(String selfLink) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected selfLink of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSelfLink = ((ServiceFluent)this.actual).getSelfLink();
        if (!Objects.areEqual((Object)actualSelfLink, (Object)selfLink)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, selfLink, actualSelfLink});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasSessionAffinity(String sessionAffinity) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected sessionAffinity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSessionAffinity = ((ServiceFluent)this.actual).getSessionAffinity();
        if (!Objects.areEqual((Object)actualSessionAffinity, (Object)sessionAffinity)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sessionAffinity, actualSessionAffinity});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }

    public S hasUid(String uid) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected uid of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualUid = ((ServiceFluent)this.actual).getUid();
        if (!Objects.areEqual((Object)actualUid, (Object)uid)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, uid, actualUid});
        }
        return (S)((Object)((AbstractServiceFluentAssert)this.myself));
    }
}

