/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class VolumeBuilder
extends VolumeFluent<VolumeBuilder>
implements Builder<Volume> {
    private final VolumeFluent<?> fluent;

    public VolumeBuilder() {
        this(new Volume());
    }

    public VolumeBuilder(VolumeFluent<?> fluent) {
        this(fluent, new Volume());
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withSource(instance.getSource());
    }

    public VolumeBuilder(Volume instance) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withSource(instance.getSource());
    }

    public Volume build() {
        Volume buildable = new Volume(this.fluent.getName(), this.fluent.getSource());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

