/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.HostDir;
import io.fabric8.kubernetes.api.model.HostDirFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HostDirBuilder
extends HostDirFluent<HostDirBuilder>
implements Builder<HostDir> {
    private final HostDirFluent<?> fluent;

    public HostDirBuilder() {
        this(new HostDir());
    }

    public HostDirBuilder(HostDirFluent<?> fluent) {
        this(fluent, new HostDir());
    }

    public HostDirBuilder(HostDirFluent<?> fluent, HostDir instance) {
        this.fluent = fluent;
        fluent.withPath(instance.getPath());
    }

    public HostDirBuilder(HostDir instance) {
        this.fluent = this;
        this.withPath(instance.getPath());
    }

    public HostDir build() {
        HostDir buildable = new HostDir(this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

