/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.Builder;
import io.fabric8.kubernetes.api.model.GCEPersistentDisk;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GCEPersistentDiskBuilder
extends GCEPersistentDiskFluent<GCEPersistentDiskBuilder>
implements Builder<GCEPersistentDisk> {
    private final GCEPersistentDiskFluent<?> fluent;

    public GCEPersistentDiskBuilder() {
        this(new GCEPersistentDisk());
    }

    public GCEPersistentDiskBuilder(GCEPersistentDiskFluent<?> fluent) {
        this(fluent, new GCEPersistentDisk());
    }

    public GCEPersistentDiskBuilder(GCEPersistentDiskFluent<?> fluent, GCEPersistentDisk instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withPartition(instance.getPartition());
        fluent.withPdName(instance.getPdName());
        fluent.withReadOnly(instance.getReadOnly());
    }

    public GCEPersistentDiskBuilder(GCEPersistentDisk instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withPartition(instance.getPartition());
        this.withPdName(instance.getPdName());
        this.withReadOnly(instance.getReadOnly());
    }

    public GCEPersistentDisk build() {
        GCEPersistentDisk buildable = new GCEPersistentDisk(this.fluent.getFsType(), this.fluent.getPartition(), this.fluent.getPdName(), this.fluent.isReadOnly());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

