/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageRepository;
import io.fabric8.openshift.api.model.Route;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "apiVersion", "creationTimestamp", "id", "items", "kind", "namespace", "resourceVersion", "selfLink", "uid"})
public class KubernetesList {
    @JsonProperty(value="annotations")
    @Valid
    private Map<String, String> annotations;
    @JsonProperty(value="apiVersion")
    private String apiVersion = "v1beta2";
    @JsonProperty(value="creationTimestamp")
    private String creationTimestamp;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="items")
    @Valid
    private List<Object> items = new ArrayList<Object>();
    @JsonIgnore
    private final List<Service> services = Collections.emptyList();
    @JsonIgnore
    private final List<ReplicationController> replicationControllers = Collections.emptyList();
    @JsonIgnore
    private final List<Pod> pods = Collections.emptyList();
    @JsonIgnore
    private final List<BuildConfig> buildConfigs = Collections.emptyList();
    @JsonIgnore
    private final List<DeploymentConfig> deploymentConfigs = Collections.emptyList();
    @JsonIgnore
    private final List<ImageRepository> imageRepositories = Collections.emptyList();
    @JsonIgnore
    private final List<Route> routes = Collections.emptyList();
    @JsonProperty(value="kind")
    private String kind = "List";
    @JsonProperty(value="namespace")
    private String namespace;
    @JsonProperty(value="resourceVersion")
    private Integer resourceVersion;
    @JsonProperty(value="selfLink")
    private String selfLink;
    @JsonProperty(value="uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public KubernetesList() {
    }

    public KubernetesList(Map<String, String> annotations, String apiVersion, String creationTimestamp, String id, List<Service> services, List<ReplicationController> replicationControllers, List<Pod> pods, List<BuildConfig> buildConfigs, List<DeploymentConfig> deploymentConfigs, List<ImageRepository> imageRepositories, List<Route> routes, List<Object> items, String kind, String namespace, Integer resourceVersion, String selfLink, String uid) {
        this.annotations = annotations;
        this.apiVersion = apiVersion;
        this.creationTimestamp = creationTimestamp;
        this.id = id;
        this.kind = kind;
        this.namespace = namespace;
        this.resourceVersion = resourceVersion;
        this.selfLink = selfLink;
        this.uid = uid;
        LinkedHashSet<Object> allItems = new LinkedHashSet<Object>();
        allItems.addAll(items != null ? items : Collections.emptyList());
        allItems.addAll(services != null ? services : Collections.emptyList());
        allItems.addAll(replicationControllers != null ? replicationControllers : Collections.emptyList());
        allItems.addAll(pods != null ? pods : Collections.emptyList());
        allItems.addAll(buildConfigs != null ? buildConfigs : Collections.emptyList());
        allItems.addAll(deploymentConfigs != null ? deploymentConfigs : Collections.emptyList());
        allItems.addAll(imageRepositories != null ? imageRepositories : Collections.emptyList());
        allItems.addAll(routes != null ? routes : Collections.emptyList());
        this.items = new ArrayList<Object>(allItems);
    }

    @JsonProperty(value="annotations")
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @JsonProperty(value="annotations")
    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="creationTimestamp")
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @JsonProperty(value="creationTimestamp")
    public void setCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="items")
    public List<Object> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    public void setItems(List<Object> items) {
        this.items = items;
    }

    @JsonIgnore
    public List<Service> getServices() {
        return this.services;
    }

    @JsonIgnore
    public List<ReplicationController> getReplicationControllers() {
        return this.replicationControllers;
    }

    @JsonIgnore
    public List<Pod> getPods() {
        return this.pods;
    }

    @JsonIgnore
    public List<BuildConfig> getBuildConfigs() {
        return this.buildConfigs;
    }

    @JsonIgnore
    public List<DeploymentConfig> getDeploymentConfigs() {
        return this.deploymentConfigs;
    }

    @JsonIgnore
    public List<ImageRepository> getImageRepositories() {
        return this.imageRepositories;
    }

    @JsonIgnore
    public List<Route> getRoutes() {
        return this.routes;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @JsonProperty(value="resourceVersion")
    public Integer getResourceVersion() {
        return this.resourceVersion;
    }

    @JsonProperty(value="resourceVersion")
    public void setResourceVersion(Integer resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @JsonProperty(value="selfLink")
    public String getSelfLink() {
        return this.selfLink;
    }

    @JsonProperty(value="selfLink")
    public void setSelfLink(String selfLink) {
        this.selfLink = selfLink;
    }

    @JsonProperty(value="uid")
    public String getUid() {
        return this.uid;
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.annotations).append((Object)this.apiVersion).append((Object)this.creationTimestamp).append((Object)this.id).append(this.items).append((Object)this.kind).append((Object)this.namespace).append((Object)this.resourceVersion).append((Object)this.selfLink).append((Object)this.uid).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KubernetesList)) {
            return false;
        }
        KubernetesList rhs = (KubernetesList)other;
        return new EqualsBuilder().append(this.annotations, rhs.annotations).append((Object)this.apiVersion, (Object)rhs.apiVersion).append((Object)this.creationTimestamp, (Object)rhs.creationTimestamp).append((Object)this.id, (Object)rhs.id).append(this.items, rhs.items).append((Object)this.kind, (Object)rhs.kind).append((Object)this.namespace, (Object)rhs.namespace).append((Object)this.resourceVersion, (Object)rhs.resourceVersion).append((Object)this.selfLink, (Object)rhs.selfLink).append((Object)this.uid, (Object)rhs.uid).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }
}

