/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.RestartPolicy;
import io.fabric8.kubernetes.api.model.Volume;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractPodSpecAssert<S extends AbstractPodSpecAssert<S, A>, A extends PodSpec>
extends AbstractAssert<S, A> {
    protected AbstractPodSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((PodSpec)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasContainers(Container ... containers) {
        this.isNotNull();
        if (containers == null) {
            throw new AssertionError((Object)"Expecting containers parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpec)this.actual).getContainers(), (Object[])containers);
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNoContainers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have containers but had :\n  <%s>";
        if (((PodSpec)this.actual).getContainers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpec)this.actual).getContainers()});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasDnsPolicy(String dnsPolicy) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected dnsPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDnsPolicy = ((PodSpec)this.actual).getDnsPolicy();
        if (!Objects.areEqual((Object)actualDnsPolicy, (Object)dnsPolicy)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, dnsPolicy, actualDnsPolicy});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasHost(String host) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualHost = ((PodSpec)this.actual).getHost();
        if (!Objects.areEqual((Object)actualHost, (Object)host)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, host, actualHost});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNodeSelector(Map nodeSelector) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected nodeSelector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualNodeSelector = ((PodSpec)this.actual).getNodeSelector();
        if (!Objects.areEqual(actualNodeSelector, (Object)nodeSelector)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, nodeSelector, actualNodeSelector});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasRestartPolicy(RestartPolicy restartPolicy) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected restartPolicy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        RestartPolicy actualRestartPolicy = ((PodSpec)this.actual).getRestartPolicy();
        if (!Objects.areEqual((Object)actualRestartPolicy, (Object)restartPolicy)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, restartPolicy, actualRestartPolicy});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasVolumes(Volume ... volumes) {
        this.isNotNull();
        if (volumes == null) {
            throw new AssertionError((Object)"Expecting volumes parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((PodSpec)this.actual).getVolumes(), (Object[])volumes);
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public S hasNoVolumes() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have volumes but had :\n  <%s>";
        if (((PodSpec)this.actual).getVolumes().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((PodSpec)this.actual).getVolumes()});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }
}

