/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.template.Template;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="oapi/v1/namespaces/{namespace}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface KubernetesExtensions {
    public static final String OSAPI_ROOT_PATH = "oapi/v1";

    @POST
    @Path(value="processedtemplates")
    @Consumes(value={"application/json"})
    public String processTemplate(Template var1, @PathParam(value="namespace") String var2) throws Exception;

    @Path(value="templates")
    @POST
    @Consumes(value={"application/json"})
    public String createTemplate(Template var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="templates/{name}")
    @Produces(value={"application/json"})
    public Template getTemplate(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="templates/{name}")
    @Consumes(value={"application/json"})
    public String updateTemplate(@PathParam(value="name") @NotNull String var1, Template var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="templates/{name}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteTemplate(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="routes")
    public RouteList getRoutes(@PathParam(value="namespace") String var1);

    @POST
    @Path(value="routes")
    public String createRoute(Route var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="routes/{name}")
    public Route getRoute(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="routes/{name}")
    @Consumes(value={"application/json"})
    public String updateRoute(@PathParam(value="name") @NotNull String var1, Route var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="routes/{name}")
    public String deleteRoute(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @GET
    @Path(value="builds")
    public BuildList getBuilds(@PathParam(value="namespace") String var1);

    @POST
    @Path(value="builds")
    public String createBuild(Build var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="builds/{name}")
    public Build getBuild(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="builds/{name}")
    @Consumes(value={"application/json"})
    public String updateBuild(@PathParam(value="name") @NotNull String var1, Build var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="builds/{name}")
    public String deleteBuild(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @GET
    @Path(value="buildconfigs")
    public BuildConfigList getBuildConfigs(@PathParam(value="namespace") String var1);

    @POST
    @Path(value="buildconfigs")
    public String createBuildConfig(BuildConfig var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="buildconfigs/{name}")
    public BuildConfig getBuildConfig(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="buildconfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateBuildConfig(@PathParam(value="name") @NotNull String var1, BuildConfig var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="buildconfigs/{name}")
    public String deleteBuildConfig(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @POST
    @Path(value="buildconfigs/{name}/webhooks/{secret}/{type}")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    public String triggerBuild(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2, @PathParam(value="secret") @NotNull String var3, @PathParam(value="type") @NotNull String var4, byte[] var5);

    @POST
    @Path(value="buildconfigs/{name}/instantiate")
    @Produces(value={"application/json"})
    public String instantiateBuild(@PathParam(value="name") String var1, BuildRequest var2, @PathParam(value="namespace") String var3);

    @GET
    @Path(value="imagestreams")
    public ImageStreamList getImageStreams(@PathParam(value="namespace") String var1);

    @POST
    @Path(value="imagestreams")
    public String createImageStream(ImageStream var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="imagestreams/{name}")
    public ImageStream getImageStream(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="imagestreams/{name}")
    @Consumes(value={"application/json"})
    public String updateImageStream(@PathParam(value="name") @NotNull String var1, ImageStream var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="imagestreams/{name}")
    public String deleteImageStream(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @GET
    @Path(value="deploymentconfigs")
    public DeploymentConfigList getDeploymentConfigs(@PathParam(value="namespace") String var1);

    @POST
    @Path(value="deploymentconfigs")
    public String createDeploymentConfig(DeploymentConfig var1, @PathParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="deploymentconfigs/{name}")
    public DeploymentConfig getDeploymentConfig(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);

    @PUT
    @Path(value="deploymentconfigs/{name}")
    @Consumes(value={"application/json"})
    public String updateDeploymentConfig(@PathParam(value="name") @NotNull String var1, DeploymentConfig var2, @PathParam(value="namespace") String var3) throws Exception;

    @DELETE
    @Path(value="deploymentconfigs/{name}")
    public String deleteDeploymentConfig(@PathParam(value="name") @NotNull String var1, @PathParam(value="namespace") String var2);
}

