/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builds;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builders.ListEnvVarBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildTriggerPolicy;
import io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.URLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class Builds {
    public static final String DEFAULT_SECRET = "secret101";
    public static final String DEFAULT_BUILD_IMAGE_STREAM = "triggerJenkins";
    public static final String DEFAULT_IMAGE_TAG = "latest";
    public static final String DEFAULT_CUSTOM_BUILDER_IMAGE = "fabric8/openshift-s2i-jenkins-trigger";

    public static BuildConfig createDefaultBuildConfig(String name, String gitUrl, String jenkinsUrl) {
        BuildConfig buildConfig = new BuildConfig();
        KubernetesHelper.getOrCreateMetadata((HasMetadata)buildConfig).setName(name);
        boolean foundExistingGitUrl = false;
        return Builds.configureDefaultBuildConfig(buildConfig, name, gitUrl, foundExistingGitUrl, jenkinsUrl);
    }

    public static BuildConfig configureDefaultBuildConfig(BuildConfig buildConfig, String name, String gitUrl, boolean foundExistingGitUrl, String jenkinsUrl) {
        return Builds.configureDefaultBuildConfig(buildConfig, name, gitUrl, foundExistingGitUrl, DEFAULT_BUILD_IMAGE_STREAM, DEFAULT_IMAGE_TAG, DEFAULT_CUSTOM_BUILDER_IMAGE, DEFAULT_SECRET, jenkinsUrl);
    }

    public static BuildConfig configureDefaultBuildConfig(BuildConfig buildConfig, String name, String gitUrl, boolean foundExistingGitUrl, String buildImageStream, String buildImageTag, String s2iCustomBuilderImage, String secret, String jenkinsUrl) {
        ArrayList<BuildTriggerPolicy> triggers;
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        if (!foundExistingGitUrl && Strings.isNotBlank((String)gitUrl)) {
            BuildSource source = spec.getSource();
            if (source == null) {
                source = new BuildSource();
                spec.setSource(source);
            }
            source.setType("Git");
            GitBuildSource git = source.getGit();
            if (git == null) {
                git = new GitBuildSource();
                source.setGit(git);
            }
            git.setUri(gitUrl);
        }
        if (Strings.isNotBlank((String)buildImageStream) && Strings.isNotBlank((String)buildImageTag)) {
            BuildStrategy strategy = spec.getStrategy();
            if (strategy == null) {
                strategy = new BuildStrategy();
                spec.setStrategy(strategy);
            }
            strategy.setType("JenkinsPipeline");
            JenkinsPipelineBuildStrategy buildStrategy = strategy.getJenkinsPipelineStrategy();
            if (buildStrategy == null) {
                buildStrategy = new JenkinsPipelineBuildStrategy();
                strategy.setJenkinsPipelineStrategy(buildStrategy);
            }
            ListEnvVarBuilder envBuilder = new ListEnvVarBuilder();
            if (Strings.isNotBlank((String)jenkinsUrl)) {
                envBuilder.withEnvVar("BASE_URI", jenkinsUrl);
            }
            buildStrategy.setJenkinsfilePath("Jenkinsfile");
        }
        if ((triggers = spec.getTriggers()) == null) {
            triggers = new ArrayList<BuildTriggerPolicy>();
        }
        if (triggers.isEmpty()) {
            triggers.add(((BuildTriggerPolicyBuilder)((BuildTriggerPolicyFluent.GithubNested)((BuildTriggerPolicyBuilder)new BuildTriggerPolicyBuilder().withType("GitHub")).withNewGithub().withSecret(secret)).endGithub()).build());
            triggers.add(((BuildTriggerPolicyBuilder)((BuildTriggerPolicyFluent.GenericNested)((BuildTriggerPolicyBuilder)new BuildTriggerPolicyBuilder().withType("Generic")).withNewGeneric().withSecret(secret)).endGeneric()).build());
            spec.setTriggers(triggers);
        }
        return buildConfig;
    }

    public static boolean isCompleted(String status) {
        return Objects.equal((Object)"Complete", (Object)status);
    }

    public static boolean isCancelled(String status) {
        return Objects.equal((Object)"Cancelled", (Object)status);
    }

    public static boolean isFailed(String status) {
        if (status != null) {
            return status.startsWith("Fail") || status.startsWith("Error");
        }
        return false;
    }

    public static boolean isFinished(String status) {
        return Builds.isCompleted(status) || Builds.isFailed(status) || Builds.isCancelled(status);
    }

    public static String getUid(Build build) {
        String answer = null;
        if (build != null) {
            answer = build.getMetadata().getUid();
            if (Strings.isNullOrBlank((String)answer)) {
                Map<String, Object> metadata = Builds.getMetadata(build);
                answer = Builds.getString(metadata, "uid");
                if (Strings.isNullOrBlank((String)answer)) {
                    answer = Builds.getString(metadata, "id");
                }
                if (Strings.isNullOrBlank((String)answer)) {
                    answer = Builds.getString(metadata, "name");
                }
            }
            if (Strings.isNullOrBlank((String)answer)) {
                answer = build.getMetadata().getName();
            }
        }
        return answer;
    }

    protected static String getString(Map<String, Object> metadata, String name) {
        Object answer = metadata.get(name);
        if (answer != null) {
            return answer.toString();
        }
        return null;
    }

    public static Map<String, Object> getMetadata(Build build) {
        Object metadata;
        Map additionalProperties;
        if (build != null && (additionalProperties = build.getAdditionalProperties()) != null && (metadata = additionalProperties.get("metadata")) instanceof Map) {
            return (Map)metadata;
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, Object> getMetadata(BuildConfig build) {
        Object metadata;
        Map additionalProperties;
        if (build != null && (additionalProperties = build.getAdditionalProperties()) != null && (metadata = additionalProperties.get("metadata")) instanceof Map) {
            return (Map)metadata;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getName(BuildConfig build) {
        Map<String, Object> metadata;
        String answer = null;
        if (build != null && Strings.isNullOrBlank((String)(answer = Builds.getString(metadata = Builds.getMetadata(build), "name")))) {
            answer = build.getMetadata().getName();
        }
        return answer;
    }

    public static String getName(Build build) {
        Map<String, Object> metadata;
        String answer = null;
        if (build != null && Strings.isNullOrBlank((String)(answer = Builds.getString(metadata = Builds.getMetadata(build), "name")))) {
            answer = build.getMetadata().getName();
        }
        return answer;
    }

    public static String getNamespace(Build build) {
        Map<String, Object> metadata;
        String answer = null;
        if (build != null && Strings.isNullOrBlank((String)(answer = Builds.getString(metadata = Builds.getMetadata(build), "namespace")))) {
            answer = build.getMetadata().getNamespace();
        }
        return answer;
    }

    public static String getCreationTimestamp(Build build) {
        Map<String, Object> metadata;
        String answer = null;
        if (build != null && Strings.isNullOrBlank((String)(answer = Builds.getString(metadata = Builds.getMetadata(build), "creationTimestamp")))) {
            answer = build.getMetadata().getCreationTimestamp();
        }
        return answer;
    }

    public static Date getCreationTimestampDate(Build build) {
        String text = Builds.getCreationTimestamp(build);
        if (Strings.isNullOrBlank((String)text)) {
            return null;
        }
        return KubernetesHelper.parseDate(text);
    }

    public static String getBuildConfigName(Build build) {
        Map<String, Object> metadata;
        Object labels;
        if (build != null && (labels = (metadata = Builds.getMetadata(build)).get("labels")) instanceof Map) {
            Map labelMap = (Map)labels;
            return Builds.getString(labelMap, "buildconfig");
        }
        return null;
    }

    public static String createConsoleBuildLink(String fabricConsoleExternalUrl, String buildName) {
        return URLUtils.pathJoin((String[])new String[]{fabricConsoleExternalUrl, "kubernetes/builds", buildName});
    }

    public static class Status {
        public static final String COMPLETE = "Complete";
        public static final String FAIL = "Fail";
        public static final String ERROR = "Error";
        public static final String CANCELLED = "Cancelled";
    }
}

