/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.Watcher;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.WatchEvent;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatcher<T extends HasMetadata>
extends WebSocketAdapter
implements Watcher<T> {
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesClient.class);
    private ObjectMapper objectMapper;

    public void onWebSocketConnect(Session sess) {
        super.onWebSocketConnect(sess);
        LOG.debug("Got connect: {}", (Object)sess);
        this.objectMapper = KubernetesFactory.createObjectMapper();
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        LOG.debug("Connection closed: {} - {}", (Object)statusCode, (Object)reason);
        this.objectMapper = null;
    }

    public void onWebSocketText(String message) {
        LOG.trace("Received message: {}", (Object)message);
        if (message != null && message.length() > 0) {
            try {
                WatchEvent event = (WatchEvent)this.objectMapper.reader(WatchEvent.class).readValue(message);
                HasMetadata obj = event.getObject();
                Watcher.Action action = Watcher.Action.valueOf(event.getType());
                this.eventReceived(action, obj);
            }
            catch (IOException e) {
                LOG.error("Could not deserialize watch event: {}", (Object)message, (Object)e);
            }
            catch (ClassCastException e) {
                LOG.error("Received wrong type of object for watch", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid event type", (Throwable)e);
            }
        }
    }

    public void onWebSocketError(Throwable cause) {
        if (cause instanceof UpgradeException) {
            LOG.error("WebSocketError: Could not upgrade connection: {}", (Object)((UpgradeException)cause).getResponseStatusCode(), (Object)cause);
        } else {
            LOG.error("WebSocketError: {}", cause);
        }
    }
}

