/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Minion;
import io.fabric8.kubernetes.api.model.MinionList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerState;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

public class KubernetesClient
implements Kubernetes,
KubernetesExtensions {
    private KubernetesFactory factoryReadOnly;
    private KubernetesFactory factoryWriteable;
    private Kubernetes kubernetes;
    private Kubernetes kubernetesWriteable;
    private KubernetesExtensions kubernetesExtensions;
    private String namespace = "";

    public KubernetesClient() {
        this(new KubernetesFactory());
    }

    public KubernetesClient(String url) {
        this(new KubernetesFactory(url));
    }

    public KubernetesClient(KubernetesFactory factory) {
        this.factoryReadOnly = factory;
    }

    public KubernetesClient(KubernetesFactory factoryReadOnly, KubernetesFactory factoryWriteable) {
        this.factoryReadOnly = factoryReadOnly;
        this.factoryWriteable = factoryWriteable;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Kubernetes getKubernetes() {
        return this.getKubernetes(false);
    }

    public Kubernetes getKubernetes(boolean writeable) {
        if (writeable) {
            if (this.kubernetesWriteable == null) {
                this.kubernetesWriteable = this.getFactory(true).createKubernetes();
            }
            return this.kubernetesWriteable;
        }
        if (this.kubernetes == null) {
            this.kubernetes = this.getFactory(false).createKubernetes();
        }
        return this.kubernetes;
    }

    public KubernetesExtensions getKubernetesExtensions() {
        if (this.kubernetesExtensions == null) {
            this.kubernetesExtensions = this.getFactory(true).createKubernetesExtensions();
        }
        return this.kubernetesExtensions;
    }

    public KubernetesFactory getFactory(boolean writeable) {
        if (writeable) {
            if (this.factoryWriteable == null) {
                this.factoryWriteable = new KubernetesFactory(true);
            }
            return this.factoryWriteable;
        }
        if (this.factoryReadOnly == null) {
            this.factoryReadOnly = new KubernetesFactory();
        }
        return this.factoryReadOnly;
    }

    public void setFactory(KubernetesFactory factory) {
        this.factoryReadOnly = this.factoryReadOnly;
    }

    public void setWriteableFactory(KubernetesFactory factory) {
        this.factoryWriteable = factory;
    }

    public String getAddress() {
        return this.getFactory(false).getAddress();
    }

    public String getWriteableAddress() {
        return this.getFactory(true).getAddress();
    }

    @GET
    @Path(value="pods")
    public PodList getPods() {
        return this.getPods(this.getNamespace());
    }

    @Override
    public PodList getPods(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getPods(namespace);
    }

    @DELETE
    @Path(value="pods/{podId}")
    public String deletePod(@NotNull String podId) throws Exception {
        return this.getWriteableKubernetes().deletePod(podId, this.getNamespace());
    }

    @Override
    @DELETE
    @Path(value="pods/{podId}")
    @Consumes(value={"text/plain"})
    public String deletePod(@NotNull String podId, String namespace) throws Exception {
        return this.getWriteableKubernetes().deletePod(podId, namespace);
    }

    @GET
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public ReplicationController getReplicationController(@NotNull String controllerId) {
        return this.getReplicationController(controllerId, this.getNamespace());
    }

    @Override
    public ReplicationController getReplicationController(@PathParam(value="controllerId") @NotNull String controllerId, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getReplicationController(controllerId, namespace);
    }

    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public String deleteReplicationController(@NotNull String controllerId) throws Exception {
        return this.getWriteableKubernetes().deleteReplicationController(controllerId, this.getNamespace());
    }

    @Override
    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteReplicationController(@NotNull String controllerId, String namespace) throws Exception {
        return this.getWriteableKubernetes().deleteReplicationController(controllerId, namespace);
    }

    @Override
    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteService(@NotNull String serviceId, String namespace) throws Exception {
        return this.getWriteableKubernetes().deleteService(serviceId, namespace);
    }

    @Path(value="replicationControllers")
    @GET
    @Produces(value={"application/json"})
    public ReplicationControllerList getReplicationControllers() {
        return this.getReplicationControllers(this.getNamespace());
    }

    @Override
    public ReplicationControllerList getReplicationControllers(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getReplicationControllers(namespace);
    }

    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationController entity) throws Exception {
        return this.updateReplicationController(controllerId, entity, this.getNamespace());
    }

    @Override
    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationController entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().updateReplicationController(controllerId, entity, namespace);
    }

    @PUT
    @Path(value="services/{serviceId}")
    @Consumes(value={"application/json"})
    public String updateService(@NotNull String serviceId, Service entity) throws Exception {
        return this.updateService(serviceId, entity, this.getNamespace());
    }

    @Override
    public String updateService(@PathParam(value="serviceId") @NotNull String serviceId, Service entity, @QueryParam(value="namespace") String namespace) throws Exception {
        return this.getWriteableKubernetes().updateService(serviceId, entity, namespace);
    }

    @GET
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public Service getService(@NotNull String serviceId) {
        return this.getService(serviceId, this.getNamespace());
    }

    @Override
    public Service getService(@PathParam(value="serviceId") @NotNull String serviceId, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getService(serviceId, namespace);
    }

    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public String deleteService(@NotNull String serviceId) throws Exception {
        return this.deleteService(serviceId, this.getNamespace());
    }

    @GET
    @Path(value="pods/{podId}")
    public Pod getPod(@NotNull String podId) {
        return this.getPod(podId, this.getNamespace());
    }

    @Override
    public Pod getPod(@PathParam(value="podId") @NotNull String podId, @QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getPod(podId, namespace);
    }

    @PUT
    @Path(value="pods/{podId}")
    @Consumes(value={"application/json"})
    public String updatePod(@NotNull String podId, Pod entity) throws Exception {
        return this.updatePod(podId, entity, this.getNamespace());
    }

    @Override
    public String updatePod(@PathParam(value="podId") @NotNull String podId, Pod entity, @QueryParam(value="namespace") String namespace) throws Exception {
        return this.getKubernetes().updatePod(podId, entity, namespace);
    }

    @Path(value="services")
    @GET
    @Produces(value={"application/json"})
    public ServiceList getServices() {
        return this.getServices(this.getNamespace());
    }

    @Override
    public ServiceList getServices(@QueryParam(value="namespace") String namespace) {
        return this.getKubernetes().getServices(namespace);
    }

    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod entity) throws Exception {
        return this.createPod(entity, this.getNamespace());
    }

    @Override
    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().createPod(entity, namespace);
    }

    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service entity) throws Exception {
        return this.createService(entity, this.getNamespace());
    }

    @Override
    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().createService(entity, namespace);
    }

    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController entity) throws Exception {
        return this.createReplicationController(entity, this.getNamespace());
    }

    @Override
    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController entity, String namespace) throws Exception {
        return this.getWriteableKubernetes().createReplicationController(entity, namespace);
    }

    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints() {
        return this.getEndpoints(this.getNamespace());
    }

    @Override
    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints(String namespace) {
        return this.getEndpoints(namespace);
    }

    @Override
    @GET
    @Path(value="endpoints/{serviceId}")
    public Endpoints endpointsForService(@NotNull String serviceId, String namespace) {
        return this.getKubernetes().endpointsForService(serviceId, namespace);
    }

    @Override
    @GET
    @Path(value="minions")
    public MinionList getMinions() {
        return this.getKubernetes().getMinions();
    }

    @Override
    @GET
    @Path(value="minions/{minionId}")
    public Minion minion(@NotNull String minionId) {
        return this.getKubernetes().minion(minionId);
    }

    @Override
    @POST
    @Path(value="configs")
    @Consumes(value={"application/json"})
    public String createConfig(Object entity) throws Exception {
        return this.getKubernetesExtensions().createConfig(entity);
    }

    @Override
    @POST
    @Path(value="template")
    @Consumes(value={"application/json"})
    public String createTemplate(Object entity) throws Exception {
        return this.getKubernetesExtensions().createTemplate(entity);
    }

    @Override
    @POST
    @Path(value="templateConfigs")
    @Consumes(value={"application/json"})
    public String createTemplateConfig(Object entity) throws Exception {
        return this.getKubernetesExtensions().createTemplateConfig(entity);
    }

    public void deletePod(Pod entity) throws Exception {
        String id = entity.getId();
        String namespace = entity.getNamespace();
        if (Strings.isNotBlank((String)namespace)) {
            this.deletePod(id, namespace);
        } else {
            this.deletePod(id);
        }
    }

    public void deleteService(Service entity) throws Exception {
        String id = entity.getId();
        String namespace = entity.getNamespace();
        if (Strings.isNotBlank((String)namespace)) {
            this.deleteService(id, namespace);
        } else {
            this.deleteService(id);
        }
    }

    public void deleteReplicationController(ReplicationController entity) throws Exception {
        String id = entity.getId();
        String namespace = entity.getNamespace();
        if (Strings.isNotBlank((String)namespace)) {
            this.deleteReplicationController(id, namespace);
        } else {
            this.deleteReplicationController(id);
        }
    }

    public ReplicationController getReplicationControllerForPod(String podId) {
        Pod pod = this.getPod(podId);
        return this.getReplicationControllerForPod(pod);
    }

    public ReplicationController getReplicationControllerForPod(Pod pod) {
        ReplicationControllerList replicationControllers;
        List<ReplicationController> items;
        Map<String, String> labels;
        if (pod != null && (labels = pod.getLabels()) != null && labels.size() > 0 && (items = (replicationControllers = this.getReplicationControllers()).getItems()) != null) {
            List nonZeroReplicas;
            int size;
            ArrayList<ReplicationController> matched = new ArrayList<ReplicationController>();
            for (ReplicationController item : items) {
                if (!KubernetesHelper.filterLabels(labels, item.getLabels())) continue;
                matched.add(item);
            }
            int matchedSize = matched.size();
            if (matchedSize > 1 && (size = (nonZeroReplicas = Filters.filter(matched, (Filter)new Filter<ReplicationController>(){

                public boolean matches(ReplicationController replicationController) {
                    Integer replicas;
                    ReplicationControllerState currentState;
                    Integer desiredReplicas;
                    ReplicationControllerState desiredState = replicationController.getDesiredState();
                    return desiredState != null && (desiredReplicas = desiredState.getReplicas()) != null && desiredReplicas > 0 && (currentState = replicationController.getCurrentState()) != null && (replicas = currentState.getReplicas()) != null && replicas > 0;
                }
            })).size()) > 0) {
                return (ReplicationController)nonZeroReplicas.get(0);
            }
            if (matchedSize >= 1) {
                return (ReplicationController)matched.get(0);
            }
        }
        return null;
    }

    public List<Pod> getPodsForReplicationController(ReplicationController service) {
        return KubernetesHelper.getPodsForReplicationController(service, this.getPodList());
    }

    public List<Pod> getPodsForReplicationController(String replicationControllerId) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerId);
        if (replicationController == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getPodsForReplicationController(replicationController);
    }

    public List<Pod> getPodsForService(Service service) {
        return KubernetesHelper.getPodsForService(service, this.getPodList());
    }

    public List<Pod> getPodsForService(String serviceId) {
        Service service = this.getService(serviceId);
        if (service == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getPodsForService(service);
    }

    protected Kubernetes getWriteableKubernetes() {
        return this.getKubernetes(true);
    }

    protected Collection<Pod> getPodList() {
        return KubernetesHelper.getPodMap(this, this.namespace).values();
    }
}

