/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Minion;
import io.fabric8.kubernetes.api.model.MinionList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="api/v1beta1")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface Kubernetes {
    @GET
    @Path(value="pods")
    public PodList getPods();

    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod var1) throws Exception;

    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(Pod var1, @QueryParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="pods/{podId}")
    public Pod getPod(@PathParam(value="podId") @NotNull String var1);

    @PUT
    @Path(value="pods/{podId}")
    @Consumes(value={"application/json"})
    public String updatePod(@PathParam(value="podId") @NotNull String var1, Pod var2) throws Exception;

    @DELETE
    @Path(value="pods/{podId}")
    @Consumes(value={"text/plain"})
    public String deletePod(@PathParam(value="podId") @NotNull String var1) throws Exception;

    @DELETE
    @Path(value="pods/{podId}")
    @Consumes(value={"text/plain"})
    public String deletePod(@PathParam(value="podId") @NotNull String var1, @QueryParam(value="namespace") String var2) throws Exception;

    @Path(value="services")
    @GET
    @Produces(value={"application/json"})
    public ServiceList getServices();

    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service var1) throws Exception;

    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(Service var1, @QueryParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public Service getService(@PathParam(value="serviceId") @NotNull String var1);

    @PUT
    @Path(value="services/{serviceId}")
    @Consumes(value={"application/json"})
    public String updateService(@PathParam(value="serviceId") @NotNull String var1, Service var2) throws Exception;

    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteService(@PathParam(value="serviceId") @NotNull String var1) throws Exception;

    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteService(@PathParam(value="serviceId") @NotNull String var1, @QueryParam(value="namespace") String var2) throws Exception;

    @Path(value="replicationControllers")
    @GET
    @Produces(value={"application/json"})
    public ReplicationControllerList getReplicationControllers();

    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController var1) throws Exception;

    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationController var1, @QueryParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public ReplicationController getReplicationController(@PathParam(value="controllerId") @NotNull String var1);

    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@PathParam(value="controllerId") @NotNull String var1, ReplicationController var2) throws Exception;

    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteReplicationController(@PathParam(value="controllerId") @NotNull String var1) throws Exception;

    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    public String deleteReplicationController(@PathParam(value="controllerId") @NotNull String var1, @QueryParam(value="namespace") String var2) throws Exception;

    @GET
    @Path(value="endpoints")
    public EndpointsList getEndpoints();

    @GET
    @Path(value="endpoints/{serviceId}")
    public Endpoints endpointsForService(@PathParam(value="serviceId") @NotNull String var1, @QueryParam(value="namespace") String var2);

    @GET
    @Path(value="minions")
    public MinionList getMinions();

    @GET
    @Path(value="minions/{minionId}")
    public Minion minion(@PathParam(value="minionId") @NotNull String var1);
}

