/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.mbeans;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerManifest;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodState;
import io.fabric8.kubernetes.api.model.Port;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppPodSummaryDTO {
    private final String id;
    private final String namespace;
    private final PodStatus status;
    private final Map<String, String> labels;
    private final Set<Integer> containerPorts = new HashSet<Integer>();
    private final String creationTimestamp;
    private String podIP;
    private String host;

    public AppPodSummaryDTO(Pod pod) {
        List<Container> containers;
        ContainerManifest manifest;
        this.id = KubernetesHelper.getId(pod);
        this.namespace = pod.getNamespace();
        this.status = KubernetesHelper.getPodStatus(pod);
        this.labels = pod.getLabels();
        this.creationTimestamp = pod.getCreationTimestamp();
        PodState currentState = pod.getCurrentState();
        PodState desiredState = pod.getDesiredState();
        if (currentState != null) {
            this.podIP = currentState.getPodIP();
            this.host = currentState.getHost();
        }
        if (desiredState != null && (manifest = desiredState.getManifest()) != null && (containers = manifest.getContainers()) != null) {
            for (Container container : containers) {
                List<Port> ports = container.getPorts();
                if (ports == null) continue;
                for (Port port : ports) {
                    Integer containerPort = port.getContainerPort();
                    if (containerPort == null) continue;
                    this.containerPorts.add(containerPort);
                }
            }
        }
    }

    public String toString() {
        return "AppPodSummaryDTO{id='" + this.id + '\'' + ", namespace='" + this.namespace + '\'' + ", status=" + (Object)((Object)this.status) + '}';
    }

    public String getId() {
        return this.id;
    }

    public PodStatus getStatus() {
        return this.status;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Set<Integer> getContainerPorts() {
        return this.containerPorts;
    }

    public String getPodIP() {
        return this.podIP;
    }

    public String getHost() {
        return this.host;
    }

    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }
}

