/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.Entity;
import io.fabric8.kubernetes.api.IntOrString;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ControllerDesiredState;
import io.fabric8.kubernetes.api.model.CurrentState;
import io.fabric8.kubernetes.api.model.DesiredState;
import io.fabric8.kubernetes.api.model.Item;
import io.fabric8.kubernetes.api.model.Manifest;
import io.fabric8.kubernetes.api.model.ManifestContainer;
import io.fabric8.kubernetes.api.model.PodCurrentContainerInfo;
import io.fabric8.kubernetes.api.model.PodListSchema;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.PodTemplate;
import io.fabric8.kubernetes.api.model.PodTemplateDesiredState;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.kubernetes.api.model.ReplicationControllerListSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ServiceListSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.kubernetes.api.model.Template;
import io.fabric8.utils.Files;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesHelper {
    public static final String DEFAULT_DOCKER_HOST = "tcp://localhost:2375";
    private static final transient Logger LOG = LoggerFactory.getLogger(KubernetesHelper.class);
    private static ObjectMapper objectMapper = KubernetesFactory.createObjectMapper();

    public static String getDockerIp() {
        String url = KubernetesHelper.resolveDockerHost();
        int idx = url.indexOf("://");
        if (idx > 0) {
            url = url.substring(idx + 3);
        }
        if ((idx = url.indexOf(":")) > 0) {
            url = url.substring(0, idx);
        }
        return url;
    }

    public static String resolveDockerHost() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (Strings.isNullOrBlank((String)dockerHost)) {
            dockerHost = System.getProperty("docker.host");
        }
        if (Strings.isNullOrBlank((String)dockerHost)) {
            return DEFAULT_DOCKER_HOST;
        }
        return dockerHost;
    }

    public static String toJson(Object dto) throws JsonProcessingException {
        Class<?> clazz = dto.getClass();
        return objectMapper.writerWithType(clazz).writeValueAsString(dto);
    }

    public static Object loadJson(File file) throws IOException {
        byte[] data = Files.readBytes((File)file);
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(InputStream in) throws IOException {
        byte[] data = Files.readBytes((InputStream)in);
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(String json) throws IOException {
        byte[] data = json.getBytes();
        return KubernetesHelper.loadJson(data);
    }

    public static Object loadJson(byte[] json) throws IOException {
        ObjectReader reader;
        JsonNode tree;
        if (json != null && json.length > 0 && (tree = (reader = objectMapper.reader()).readTree((InputStream)new ByteArrayInputStream(json))) != null) {
            JsonNode kindNode = tree.get("kind");
            if (kindNode != null) {
                String kind = kindNode.asText();
                return KubernetesHelper.loadEntity(json, kind, tree);
            }
            LOG.warn("No JSON type for: " + tree);
            return tree;
        }
        return null;
    }

    protected static Object loadEntity(byte[] json, String kind, Object defaultValue) throws IOException {
        if (Objects.equal((Object)"Pod", (Object)kind)) {
            return objectMapper.reader(PodSchema.class).readValue(json);
        }
        if (Objects.equal((Object)"ReplicationController", (Object)kind)) {
            return objectMapper.reader(ReplicationControllerSchema.class).readValue(json);
        }
        if (Objects.equal((Object)"Service", (Object)kind)) {
            return objectMapper.reader(ServiceSchema.class).readValue(json);
        }
        if (Objects.equal((Object)"Config", (Object)kind)) {
            return objectMapper.reader(Config.class).readValue(json);
        }
        if (Objects.equal((Object)"Template", (Object)kind)) {
            return objectMapper.reader(Template.class).readValue(json);
        }
        return defaultValue;
    }

    public static Entity getEntity(Item item) throws IOException {
        String json;
        byte[] bytes;
        Object entity;
        String kind;
        if (item != null && (kind = item.getKind()) != null && (entity = KubernetesHelper.loadEntity(bytes = (json = KubernetesHelper.toJson(item)).getBytes(), kind, null)) instanceof Entity) {
            return (Entity)entity;
        }
        return null;
    }

    public static List<Entity> getEntities(Config config) throws IOException {
        List<Item> items;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (config != null && (items = config.getItems()) != null) {
            for (Item item : items) {
                Entity entity = KubernetesHelper.getEntity(item);
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public static void saveJson(File json, Object object) throws IOException {
        objectMapper.writer().writeValue(json, object);
    }

    public static Map<String, PodSchema> toPodMap(PodListSchema podSchema) {
        return KubernetesHelper.toPodMap(podSchema, null);
    }

    public static Map<String, PodSchema> toPodMap(PodListSchema podSchema, String selector) {
        List<PodSchema> list = podSchema != null ? podSchema.getItems() : null;
        List filteredList = Filters.filter(list, KubernetesHelper.createPodFilter(selector));
        return KubernetesHelper.toPodMap(filteredList);
    }

    public static Map<String, PodSchema> toPodMap(List<PodSchema> pods) {
        List list = Lists.notNullList(pods);
        HashMap<String, PodSchema> answer = new HashMap<String, PodSchema>();
        for (PodSchema podSchema : list) {
            String id = podSchema.getId();
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, podSchema);
        }
        return answer;
    }

    public static Map<String, ServiceSchema> toServiceMap(ServiceListSchema serviceSchema) {
        return KubernetesHelper.toServiceMap(serviceSchema != null ? serviceSchema.getItems() : null);
    }

    public static Map<String, ServiceSchema> toServiceMap(List<ServiceSchema> services) {
        List list = Lists.notNullList(services);
        HashMap<String, ServiceSchema> answer = new HashMap<String, ServiceSchema>();
        for (ServiceSchema serviceSchema : list) {
            String id = serviceSchema.getId();
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, serviceSchema);
        }
        return answer;
    }

    public static Map<String, ReplicationControllerSchema> toReplicationControllerMap(ReplicationControllerListSchema replicationControllerSchema) {
        return KubernetesHelper.toReplicationControllerMap(replicationControllerSchema, null);
    }

    private static Map<String, ReplicationControllerSchema> toReplicationControllerMap(ReplicationControllerListSchema replicationControllerSchema, String selector) {
        List<ReplicationControllerSchema> list = replicationControllerSchema != null ? replicationControllerSchema.getItems() : null;
        List filteredList = Filters.filter(list, KubernetesHelper.createReplicationControllerFilter(selector));
        return KubernetesHelper.toReplicationControllerMap(filteredList);
    }

    public static Map<String, ReplicationControllerSchema> toReplicationControllerMap(List<ReplicationControllerSchema> replicationControllers) {
        List list = Lists.notNullList(replicationControllers);
        HashMap<String, ReplicationControllerSchema> answer = new HashMap<String, ReplicationControllerSchema>();
        for (ReplicationControllerSchema replicationControllerSchema : list) {
            String id = replicationControllerSchema.getId();
            if (!Strings.isNotBlank((String)id)) continue;
            answer.put(id, replicationControllerSchema);
        }
        return answer;
    }

    public static Map<String, PodSchema> getPodMap(Kubernetes kubernetes) {
        return KubernetesHelper.getPodMap(kubernetes, null);
    }

    public static Map<String, PodSchema> getPodMap(Kubernetes kubernetes, String selector) {
        PodListSchema podSchema = kubernetes.getPods();
        return KubernetesHelper.toPodMap(podSchema, selector);
    }

    public static Map<String, ServiceSchema> getServiceMap(Kubernetes kubernetes) {
        return KubernetesHelper.toServiceMap(kubernetes.getServices());
    }

    public static Map<String, ReplicationControllerSchema> getReplicationControllerMap(Kubernetes kubernetes) {
        return KubernetesHelper.toReplicationControllerMap(kubernetes.getReplicationControllers());
    }

    public static Map<String, ReplicationControllerSchema> getReplicationControllerMap(Kubernetes kubernetes, String selector) {
        return KubernetesHelper.toReplicationControllerMap(kubernetes.getReplicationControllers(), selector);
    }

    public static void removeEmptyPods(PodListSchema podSchema) {
        List list = Lists.notNullList(podSchema.getItems());
        ArrayList<PodSchema> removeItems = new ArrayList<PodSchema>();
        for (PodSchema serviceSchema : list) {
            if (!StringUtils.isEmpty((String)serviceSchema.getId())) continue;
            removeItems.add(serviceSchema);
        }
        list.removeAll(removeItems);
    }

    public static String containerNameToPodId(String containerName) {
        return containerName;
    }

    public static String toLabelsString(Map<String, String> labelMap) {
        StringBuilder buffer = new StringBuilder();
        if (labelMap != null) {
            Set<Map.Entry<String, String>> entries = labelMap.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(entry.getKey());
                buffer.append("=");
                buffer.append(entry.getValue());
            }
        }
        return buffer.toString();
    }

    public static Map<String, String> toLabelsMap(String labels) {
        String[] elements;
        HashMap<String, String> map = new HashMap<String, String>();
        if (labels != null && !labels.isEmpty() && (elements = labels.split(",")).length > 0) {
            for (String str : elements) {
                String[] keyValue = str.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                if (key == null || value == null) continue;
                map.put(key.trim(), value.trim());
            }
        }
        return map;
    }

    public static Filter<PodSchema> createPodFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<PodSchema>(){

            public String toString() {
                return "PodFilter(" + textFilter + ")";
            }

            public boolean matches(PodSchema entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, entity.getId(), entity.getLabels());
            }
        };
    }

    public static Filter<PodSchema> createPodFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<PodSchema>(){

            public String toString() {
                return "PodFilter(" + labelSelector + ")";
            }

            public boolean matches(PodSchema entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getLabels());
            }
        };
    }

    public static Filter<PodSchema> createPodAnnotationFilter(final Map<String, String> annotationSelector) {
        if (annotationSelector == null || annotationSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<PodSchema>(){

            public String toString() {
                return "PodAnnotationFilter(" + annotationSelector + ")";
            }

            public boolean matches(PodSchema entity) {
                return KubernetesHelper.filterLabels(annotationSelector, entity.getAnnotations());
            }
        };
    }

    public static Filter<ServiceSchema> createServiceFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<ServiceSchema>(){

            public String toString() {
                return "ServiceFilter(" + textFilter + ")";
            }

            public boolean matches(ServiceSchema entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, entity.getId(), entity.getLabels());
            }
        };
    }

    public static Filter<ServiceSchema> createServiceFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<ServiceSchema>(){

            public String toString() {
                return "ServiceFilter(" + labelSelector + ")";
            }

            public boolean matches(ServiceSchema entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getLabels());
            }
        };
    }

    public static Filter<ReplicationControllerSchema> createReplicationControllerFilter(final String textFilter) {
        if (Strings.isNullOrBlank((String)textFilter)) {
            return Filters.trueFilter();
        }
        return new Filter<ReplicationControllerSchema>(){

            public String toString() {
                return "ReplicationControllerFilter(" + textFilter + ")";
            }

            public boolean matches(ReplicationControllerSchema entity) {
                return KubernetesHelper.filterMatchesIdOrLabels(textFilter, entity.getId(), entity.getLabels());
            }
        };
    }

    public static Filter<ReplicationControllerSchema> createReplicationControllerFilter(final Map<String, String> labelSelector) {
        if (labelSelector == null || labelSelector.isEmpty()) {
            return Filters.trueFilter();
        }
        return new Filter<ReplicationControllerSchema>(){

            public String toString() {
                return "ReplicationControllerFilter(" + labelSelector + ")";
            }

            public boolean matches(ReplicationControllerSchema entity) {
                return KubernetesHelper.filterLabels(labelSelector, entity.getLabels());
            }
        };
    }

    public static boolean filterMatchesIdOrLabels(String textFilter, String id, Map<String, String> labels) {
        Map<String, String> selectorMap;
        boolean result;
        String text = KubernetesHelper.toLabelsString(labels);
        boolean bl = result = text != null && text.contains(textFilter) || id != null && id.contains(textFilter);
        if (!result && !(selectorMap = KubernetesHelper.toLabelsMap(textFilter)).isEmpty()) {
            result = true;
            for (Map.Entry<String, String> entry : selectorMap.entrySet()) {
                String value = labels.get(entry.getKey());
                if (value != null && value.matches(entry.getValue())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean filterLabels(Map<String, String> filterLabels, Map<String, String> labels) {
        if (labels == null) {
            return false;
        }
        Set<Map.Entry<String, String>> entries = filterLabels.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String actualValue;
            String key = entry.getKey();
            String expectedValue = entry.getValue();
            if (Objects.equal((Object)expectedValue, (Object)(actualValue = labels.get(key)))) continue;
            return false;
        }
        return true;
    }

    public static String toPositiveNonZeroText(Integer port) {
        int value;
        if (port != null && (value = port.intValue()) > 0) {
            return "" + value;
        }
        return "";
    }

    public static List<ManifestContainer> getContainers(PodSchema pod) {
        if (pod != null) {
            DesiredState desiredState = pod.getDesiredState();
            return KubernetesHelper.getContainers(desiredState);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getContainers(ReplicationControllerSchema replicationController) {
        if (replicationController != null) {
            ControllerDesiredState desiredState = replicationController.getDesiredState();
            return KubernetesHelper.getContainers(desiredState);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getContainers(ControllerDesiredState desiredState) {
        if (desiredState != null) {
            PodTemplate podTemplate = desiredState.getPodTemplate();
            return KubernetesHelper.getContainers(podTemplate);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getContainers(PodTemplate podTemplate) {
        if (podTemplate != null) {
            PodTemplateDesiredState podTemplateDesiredState = podTemplate.getDesiredState();
            return KubernetesHelper.getContainers(podTemplateDesiredState);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getContainers(PodTemplateDesiredState podTemplateDesiredState) {
        if (podTemplateDesiredState != null) {
            Manifest manifest = podTemplateDesiredState.getManifest();
            return KubernetesHelper.getContainers(manifest);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getContainers(Manifest manifest) {
        List<ManifestContainer> containers;
        if (manifest != null && (containers = manifest.getContainers()) != null) {
            return containers;
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getCurrentContainers(ReplicationControllerSchema replicationController) {
        if (replicationController != null) {
            // empty if block
        }
        return Collections.EMPTY_LIST;
    }

    public static List<ManifestContainer> getContainers(DesiredState desiredState) {
        List<ManifestContainer> containers;
        Manifest manifest;
        if (desiredState != null && (manifest = desiredState.getManifest()) != null && (containers = manifest.getContainers()) != null) {
            return containers;
        }
        return Collections.EMPTY_LIST;
    }

    public static Map<String, PodCurrentContainerInfo> getCurrentContainers(PodSchema pod) {
        if (pod != null) {
            CurrentState currentState = pod.getCurrentState();
            return KubernetesHelper.getCurrentContainers(currentState);
        }
        return Collections.EMPTY_MAP;
    }

    public static Map<String, PodCurrentContainerInfo> getCurrentContainers(CurrentState currentState) {
        Map<String, PodCurrentContainerInfo> info;
        if (currentState != null && (info = currentState.getInfo()) != null) {
            return info;
        }
        return Collections.EMPTY_MAP;
    }

    public static String getHost(PodSchema pod) {
        CurrentState currentState;
        if (pod != null && (currentState = pod.getCurrentState()) != null) {
            return currentState.getHost();
        }
        return null;
    }

    public static int getContainerPort(ServiceSchema service) {
        int answer;
        String id = service.getId();
        IntOrString containerPort = service.getContainerPort();
        Objects.notNull((Object)containerPort, (String)("containerPort for service " + id));
        Integer intValue = containerPort.getIntValue();
        if (intValue != null) {
            answer = intValue;
        } else {
            String containerPortText = containerPort.getStringValue();
            if (Strings.isNullOrBlank((String)containerPortText)) {
                throw new IllegalArgumentException("No containerPort for service " + id);
            }
            try {
                answer = Integer.parseInt(containerPortText);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Invalid containerPort expression " + containerPortText + " for service " + id + ". " + e, e);
            }
        }
        if (answer <= 0) {
            throw new IllegalArgumentException("Invalid port number for service " + id + ". " + answer);
        }
        return answer;
    }

    public static JsonNode combineJson(Object ... objects) throws IOException {
        ArrayNode itemArray;
        JsonNode config = KubernetesHelper.findOrCreateConfig(objects);
        JsonNode items = config.get("items");
        if (items instanceof ArrayNode) {
            itemArray = (ArrayNode)items;
        } else {
            itemArray = new ArrayNode(KubernetesHelper.createNodeFactory());
            if (config instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)config;
                objectNode.set("items", (JsonNode)itemArray);
            } else {
                throw new IllegalArgumentException("config " + config + " is not a ObjectNode");
            }
        }
        for (Object object : objects) {
            if (object == config) continue;
            KubernetesHelper.addObjectsToItemArray(itemArray, object);
        }
        return config;
    }

    protected static void addObjectsToItemArray(ArrayNode itemArray, Object object) throws IOException {
        JsonNode node = KubernetesHelper.toJsonNode(object);
        JsonNode items = node.get("items");
        if (items != null && items.isArray()) {
            Iterator iter = items.iterator();
            for (JsonNode item : items) {
                itemArray.add(item);
            }
        } else {
            itemArray.add(node);
        }
    }

    protected static JsonNodeFactory createNodeFactory() {
        return new JsonNodeFactory(false);
    }

    protected static JsonNode findOrCreateConfig(Object[] objects) {
        for (Object object : objects) {
            JsonNode jsonNode;
            JsonNode items;
            if (!(object instanceof JsonNode) || (items = (jsonNode = (JsonNode)object).get("items")) == null || !items.isArray()) continue;
            return jsonNode;
        }
        JsonNodeFactory factory = KubernetesHelper.createNodeFactory();
        ObjectNode config = factory.objectNode();
        config.set("apiVersion", (JsonNode)factory.textNode("v1beta1"));
        config.set("kind", (JsonNode)factory.textNode("Config"));
        config.set("items", (JsonNode)factory.arrayNode());
        return config;
    }

    public static JsonNode toJsonNode(Object object) throws IOException {
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        if (object == null) {
            return null;
        }
        String json = KubernetesHelper.toJson(object);
        return objectMapper.reader().readTree(json);
    }

    public static String getServiceURL(ServiceSchema service) {
        if (service != null) {
            Integer port;
            String portalIP = service.getPortalIP();
            if (portalIP != null && (port = service.getPort()) != null && port > 0) {
                portalIP = portalIP + ":" + port;
            }
            String protocol = "http://";
            return protocol + portalIP;
        }
        return null;
    }

    public static Port findContainerPort(PodSchema pod, Integer portNumber) {
        List<ManifestContainer> containers = KubernetesHelper.getContainers(pod);
        for (ManifestContainer container : containers) {
            List<Port> ports = container.getPorts();
            for (Port port : ports) {
                if (!Objects.equal((Object)portNumber, (Object)port.getContainerPort())) continue;
                return port;
            }
        }
        return null;
    }

    public static Port findContainerPortByName(PodSchema pod, String name) {
        List<ManifestContainer> containers = KubernetesHelper.getContainers(pod);
        for (ManifestContainer container : containers) {
            List<Port> ports = container.getPorts();
            for (Port port : ports) {
                if (!Objects.equal((Object)name, (Object)port.getName())) continue;
                return port;
            }
        }
        return null;
    }

    public static Port findContainerPortByNumberOrName(PodSchema pod, String numberOrName) {
        Integer portNumber = KubernetesHelper.toOptionalNumber(numberOrName);
        if (portNumber != null) {
            return KubernetesHelper.findContainerPort(pod, portNumber);
        }
        return KubernetesHelper.findContainerPortByName(pod, numberOrName);
    }

    protected static Integer toOptionalNumber(String text) {
        if (Strings.isNotBlank((String)text)) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static PodTemplateDesiredState getPodTemplateDesiredState(ReplicationControllerSchema replicationController) {
        if (replicationController != null) {
            return KubernetesHelper.getPodTemplateDesiredState(replicationController.getDesiredState());
        }
        return null;
    }

    public static PodTemplateDesiredState getPodTemplateDesiredState(ControllerDesiredState desiredState) {
        PodTemplate podTemplate;
        PodTemplateDesiredState podTemplateDesiredState = null;
        if (desiredState != null && (podTemplate = desiredState.getPodTemplate()) != null) {
            podTemplateDesiredState = podTemplate.getDesiredState();
        }
        return podTemplateDesiredState;
    }

    public static PodStatus getPodStatus(PodSchema pod) {
        String text = KubernetesHelper.getPodStatusText(pod);
        if (Strings.isNotBlank((String)text)) {
            if ((text = text.toLowerCase()).startsWith("run")) {
                return PodStatus.OK;
            }
            if (text.startsWith("wait")) {
                return PodStatus.WAIT;
            }
            return PodStatus.ERROR;
        }
        return PodStatus.WAIT;
    }

    public static String getPodStatusText(PodSchema pod) {
        CurrentState currentState;
        if (pod != null && (currentState = pod.getCurrentState()) != null) {
            return currentState.getStatus();
        }
        return null;
    }

    public static List<PodSchema> getPodsForReplicationController(ReplicationControllerSchema replicationController, Iterable<PodSchema> pods) {
        PodTemplateDesiredState podTemplateDesiredState = KubernetesHelper.getPodTemplateDesiredState(replicationController);
        if (podTemplateDesiredState == null) {
            LOG.warn("Cannot instantiate replication controller: " + replicationController.getId() + " due to missing PodTemplate.DesiredState!");
        } else {
            ControllerDesiredState desiredState = replicationController.getDesiredState();
            if (desiredState != null) {
                Map<String, String> replicaSelector = desiredState.getReplicaSelector();
                Filter<PodSchema> podFilter = KubernetesHelper.createPodFilter(replicaSelector);
                return Filters.filter(pods, podFilter);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static List<PodSchema> getPodsForService(ServiceSchema service, Iterable<PodSchema> pods) {
        Map<String, String> selector = service.getSelector();
        Filter<PodSchema> podFilter = KubernetesHelper.createPodFilter(selector);
        return Filters.filter(pods, podFilter);
    }
}

