/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesExtensions;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ControllerCurrentState;
import io.fabric8.kubernetes.api.model.ControllerDesiredState;
import io.fabric8.kubernetes.api.model.PodListSchema;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerListSchema;
import io.fabric8.kubernetes.api.model.ReplicationControllerSchema;
import io.fabric8.kubernetes.api.model.ServiceListSchema;
import io.fabric8.kubernetes.api.model.ServiceSchema;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Filters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

public class KubernetesClient
implements Kubernetes,
KubernetesExtensions {
    private KubernetesFactory factory;
    private Kubernetes kubernetes;
    private KubernetesExtensions kubernetesExtensions;

    public KubernetesClient() {
    }

    public KubernetesClient(String url) {
        this(new KubernetesFactory(url));
    }

    public KubernetesClient(KubernetesFactory factory) {
        this.factory = factory;
    }

    public Kubernetes getKubernetes() {
        if (this.kubernetes == null) {
            this.kubernetes = this.getFactory().createKubernetes();
        }
        return this.kubernetes;
    }

    public KubernetesExtensions getKubernetesExtensions() {
        if (this.kubernetesExtensions == null) {
            this.kubernetesExtensions = this.getFactory().createKubernetesExtensions();
        }
        return this.kubernetesExtensions;
    }

    public KubernetesFactory getFactory() {
        if (this.factory == null) {
            this.factory = new KubernetesFactory();
        }
        return this.factory;
    }

    public void setFactory(KubernetesFactory factory) {
        this.factory = factory;
    }

    public String getAddress() {
        return this.getFactory().getAddress();
    }

    @Override
    @GET
    @Path(value="pods")
    public PodListSchema getPods() {
        return this.getKubernetes().getPods();
    }

    @Override
    @DELETE
    @Path(value="pods/{podId}")
    public String deletePod(@NotNull String podId) throws Exception {
        return this.getKubernetes().deletePod(podId);
    }

    @Override
    @GET
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public ReplicationControllerSchema getReplicationController(@NotNull String controllerId) {
        return this.getKubernetes().getReplicationController(controllerId);
    }

    @Override
    @DELETE
    @Path(value="replicationControllers/{controllerId}")
    @Produces(value={"application/json"})
    public String deleteReplicationController(@NotNull String controllerId) throws Exception {
        return this.getKubernetes().deleteReplicationController(controllerId);
    }

    @Override
    @Path(value="replicationControllers")
    @GET
    @Produces(value={"application/json"})
    public ReplicationControllerListSchema getReplicationControllers() {
        return this.getKubernetes().getReplicationControllers();
    }

    @Override
    @PUT
    @Path(value="replicationControllers/{controllerId}")
    @Consumes(value={"application/json"})
    public String updateReplicationController(@NotNull String controllerId, ReplicationControllerSchema entity) throws Exception {
        return this.getKubernetes().updateReplicationController(controllerId, entity);
    }

    @Override
    @PUT
    @Path(value="services/{serviceId}")
    @Consumes(value={"application/json"})
    public String updateService(@NotNull String serviceId, ServiceSchema entity) throws Exception {
        return this.getKubernetes().updateService(serviceId, entity);
    }

    @Override
    @GET
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public ServiceSchema getService(@NotNull String serviceId) {
        return this.getKubernetes().getService(serviceId);
    }

    @Override
    @DELETE
    @Path(value="services/{serviceId}")
    @Produces(value={"application/json"})
    public String deleteService(@NotNull String serviceId) throws Exception {
        return this.getKubernetes().deleteService(serviceId);
    }

    @Override
    @Path(value="services")
    @POST
    @Consumes(value={"application/json"})
    public String createService(ServiceSchema entity) throws Exception {
        return this.getKubernetes().createService(entity);
    }

    @Override
    @GET
    @Path(value="pods/{podId}")
    public PodSchema getPod(@NotNull String podId) {
        return this.getKubernetes().getPod(podId);
    }

    @Override
    @PUT
    @Path(value="pods/{podId}")
    @Consumes(value={"application/json"})
    public String updatePod(@NotNull String podId, PodSchema entity) throws Exception {
        return this.getKubernetes().updatePod(podId, entity);
    }

    @Override
    @Path(value="services")
    @GET
    @Produces(value={"application/json"})
    public ServiceListSchema getServices() {
        return this.getKubernetes().getServices();
    }

    @Override
    @POST
    @Path(value="pods")
    @Consumes(value={"application/json"})
    public String createPod(PodSchema entity) throws Exception {
        return this.getKubernetes().createPod(entity);
    }

    @Override
    @Path(value="replicationControllers")
    @POST
    @Consumes(value={"application/json"})
    public String createReplicationController(ReplicationControllerSchema entity) throws Exception {
        return this.getKubernetes().createReplicationController(entity);
    }

    @Override
    @POST
    @Path(value="configs")
    @Consumes(value={"application/json"})
    public String createConfig(Object entity) throws Exception {
        return this.getKubernetesExtensions().createConfig(entity);
    }

    @Override
    @POST
    @Path(value="template")
    @Consumes(value={"application/json"})
    public String createTemplate(Object entity) throws Exception {
        return this.getKubernetesExtensions().createTemplate(entity);
    }

    @Override
    @POST
    @Path(value="templateConfigs")
    @Consumes(value={"application/json"})
    public String createTemplateConfig(Object entity) throws Exception {
        return this.getKubernetesExtensions().createTemplateConfig(entity);
    }

    public ReplicationControllerSchema getReplicationControllerForPod(String podId) {
        PodSchema pod = this.getPod(podId);
        return this.getReplicationControllerForPod(pod);
    }

    public ReplicationControllerSchema getReplicationControllerForPod(PodSchema pod) {
        ReplicationControllerListSchema replicationControllers;
        List<ReplicationControllerSchema> items;
        Map<String, String> labels;
        if (pod != null && (labels = pod.getLabels()) != null && labels.size() > 0 && (items = (replicationControllers = this.getReplicationControllers()).getItems()) != null) {
            List nonZeroReplicas;
            int size;
            ArrayList<ReplicationControllerSchema> matched = new ArrayList<ReplicationControllerSchema>();
            for (ReplicationControllerSchema item : items) {
                if (!KubernetesHelper.filterLabels(labels, item.getLabels())) continue;
                matched.add(item);
            }
            int matchedSize = matched.size();
            if (matchedSize > 1 && (size = (nonZeroReplicas = Filters.filter(matched, (Filter)new Filter<ReplicationControllerSchema>(){

                public boolean matches(ReplicationControllerSchema replicationController) {
                    Integer replicas;
                    ControllerCurrentState currentState;
                    Integer desiredReplicas;
                    ControllerDesiredState desiredState = replicationController.getDesiredState();
                    return desiredState != null && (desiredReplicas = desiredState.getReplicas()) != null && desiredReplicas > 0 && (currentState = replicationController.getCurrentState()) != null && (replicas = currentState.getReplicas()) != null && replicas > 0;
                }
            })).size()) > 0) {
                return (ReplicationControllerSchema)nonZeroReplicas.get(0);
            }
            if (matchedSize >= 1) {
                return (ReplicationControllerSchema)matched.get(0);
            }
        }
        return null;
    }
}

