/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1alpha1;

import io.fabric8.knative.duck.v1.CloudEventOverrides;
import io.fabric8.knative.duck.v1.CloudEventOverridesBuilder;
import io.fabric8.knative.duck.v1.CloudEventOverridesFluent;
import io.fabric8.knative.duck.v1.Destination;
import io.fabric8.knative.duck.v1.DestinationBuilder;
import io.fabric8.knative.duck.v1.DestinationFluent;
import io.fabric8.knative.sources.v1alpha1.Aws;
import io.fabric8.knative.sources.v1alpha1.AwsBuilder;
import io.fabric8.knative.sources.v1alpha1.AwsFluent;
import io.fabric8.knative.sources.v1alpha1.IntegrationSourceSpec;
import io.fabric8.knative.sources.v1alpha1.Timer;
import io.fabric8.knative.sources.v1alpha1.TimerBuilder;
import io.fabric8.knative.sources.v1alpha1.TimerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IntegrationSourceSpecFluent<A extends IntegrationSourceSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AwsBuilder aws;
    private CloudEventOverridesBuilder ceOverrides;
    private DestinationBuilder sink;
    private PodTemplateSpecBuilder template;
    private TimerBuilder timer;

    public IntegrationSourceSpecFluent() {
    }

    public IntegrationSourceSpecFluent(IntegrationSourceSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public Aws buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public CloudEventOverrides buildCeOverrides() {
        return this.ceOverrides != null ? this.ceOverrides.build() : null;
    }

    public Destination buildSink() {
        return this.sink != null ? this.sink.build() : null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public Timer buildTimer() {
        return this.timer != null ? this.timer.build() : null;
    }

    protected void copyInstance(IntegrationSourceSpec instance) {
        IntegrationSourceSpec integrationSourceSpec = instance = instance != null ? instance : new IntegrationSourceSpec();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withCeOverrides(instance.getCeOverrides());
            this.withSink(instance.getSink());
            this.withTemplate(instance.getTemplate());
            this.withTimer(instance.getTimer());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public CeOverridesNested<A> editCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AwsBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(Aws item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public CeOverridesNested<A> editOrNewCeOverrides() {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(new CloudEventOverridesBuilder().build()));
    }

    public CeOverridesNested<A> editOrNewCeOverridesLike(CloudEventOverrides item) {
        return this.withNewCeOverridesLike(Optional.ofNullable(this.buildCeOverrides()).orElse(item));
    }

    public SinkNested<A> editOrNewSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(new DestinationBuilder().build()));
    }

    public SinkNested<A> editOrNewSinkLike(Destination item) {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(item));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public TimerNested<A> editOrNewTimer() {
        return this.withNewTimerLike(Optional.ofNullable(this.buildTimer()).orElse(new TimerBuilder().build()));
    }

    public TimerNested<A> editOrNewTimerLike(Timer item) {
        return this.withNewTimerLike(Optional.ofNullable(this.buildTimer()).orElse(item));
    }

    public SinkNested<A> editSink() {
        return this.withNewSinkLike(Optional.ofNullable(this.buildSink()).orElse(null));
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TimerNested<A> editTimer() {
        return this.withNewTimerLike(Optional.ofNullable(this.buildTimer()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationSourceSpecFluent that = (IntegrationSourceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.aws, (Object)that.aws)) {
            return false;
        }
        if (!Objects.equals((Object)this.ceOverrides, (Object)that.ceOverrides)) {
            return false;
        }
        if (!Objects.equals((Object)this.sink, (Object)that.sink)) {
            return false;
        }
        if (!Objects.equals(this.template, that.template)) {
            return false;
        }
        if (!Objects.equals((Object)this.timer, (Object)that.timer)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public boolean hasCeOverrides() {
        return this.ceOverrides != null;
    }

    public boolean hasSink() {
        return this.sink != null;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public boolean hasTimer() {
        return this.timer != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aws, this.ceOverrides, this.sink, this.template, this.timer, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append((Object)this.aws);
            sb.append(",");
        }
        if (this.ceOverrides != null) {
            sb.append("ceOverrides:");
            sb.append((Object)this.ceOverrides);
            sb.append(",");
        }
        if (this.sink != null) {
            sb.append("sink:");
            sb.append((Object)this.sink);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template);
            sb.append(",");
        }
        if (this.timer != null) {
            sb.append("timer:");
            sb.append((Object)this.timer);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAws(Aws aws) {
        this._visitables.remove((Object)"aws");
        if (aws != null) {
            this.aws = new AwsBuilder(aws);
            this._visitables.get((Object)"aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get((Object)"aws").remove((Object)this.aws);
        }
        return (A)((Object)this);
    }

    public A withCeOverrides(CloudEventOverrides ceOverrides) {
        this._visitables.remove((Object)"ceOverrides");
        if (ceOverrides != null) {
            this.ceOverrides = new CloudEventOverridesBuilder(ceOverrides);
            this._visitables.get((Object)"ceOverrides").add(this.ceOverrides);
        } else {
            this.ceOverrides = null;
            this._visitables.get((Object)"ceOverrides").remove((Object)this.ceOverrides);
        }
        return (A)((Object)this);
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(Aws item) {
        return new AwsNested(item);
    }

    public CeOverridesNested<A> withNewCeOverrides() {
        return new CeOverridesNested(null);
    }

    public CeOverridesNested<A> withNewCeOverridesLike(CloudEventOverrides item) {
        return new CeOverridesNested(item);
    }

    public SinkNested<A> withNewSink() {
        return new SinkNested(null);
    }

    public SinkNested<A> withNewSinkLike(Destination item) {
        return new SinkNested(item);
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TimerNested<A> withNewTimer() {
        return new TimerNested(null);
    }

    public A withNewTimer(String contentType, String message, Integer period, Integer repeatCount) {
        return this.withTimer(new Timer(contentType, message, period, repeatCount));
    }

    public TimerNested<A> withNewTimerLike(Timer item) {
        return new TimerNested(item);
    }

    public A withSink(Destination sink) {
        this._visitables.remove((Object)"sink");
        if (sink != null) {
            this.sink = new DestinationBuilder(sink);
            this._visitables.get((Object)"sink").add(this.sink);
        } else {
            this.sink = null;
            this._visitables.get((Object)"sink").remove((Object)this.sink);
        }
        return (A)((Object)this);
    }

    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove(this.template);
        }
        return (A)((Object)this);
    }

    public A withTimer(Timer timer) {
        this._visitables.remove((Object)"timer");
        if (timer != null) {
            this.timer = new TimerBuilder(timer);
            this._visitables.get((Object)"timer").add(this.timer);
        } else {
            this.timer = null;
            this._visitables.get((Object)"timer").remove((Object)this.timer);
        }
        return (A)((Object)this);
    }

    public class TimerNested<N>
    extends TimerFluent<TimerNested<N>>
    implements Nested<N> {
        TimerBuilder builder;

        TimerNested(Timer item) {
            this.builder = new TimerBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationSourceSpecFluent.this.withTimer(this.builder.build());
        }

        public N endTimer() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNested(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder((PodTemplateSpecFluent)this, item);
        }

        public N and() {
            return (N)IntegrationSourceSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }

    public class SinkNested<N>
    extends DestinationFluent<SinkNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SinkNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationSourceSpecFluent.this.withSink(this.builder.build());
        }

        public N endSink() {
            return this.and();
        }
    }

    public class CeOverridesNested<N>
    extends CloudEventOverridesFluent<CeOverridesNested<N>>
    implements Nested<N> {
        CloudEventOverridesBuilder builder;

        CeOverridesNested(CloudEventOverrides item) {
            this.builder = new CloudEventOverridesBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationSourceSpecFluent.this.withCeOverrides(this.builder.build());
        }

        public N endCeOverrides() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AwsFluent<AwsNested<N>>
    implements Nested<N> {
        AwsBuilder builder;

        AwsNested(Aws item) {
            this.builder = new AwsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationSourceSpecFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

