/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.duck.v1.AuthStatus;
import io.fabric8.knative.duck.v1.AuthStatusBuilder;
import io.fabric8.knative.duck.v1.AuthStatusFluent;
import io.fabric8.knative.eventing.v1.TriggerStatus;
import io.fabric8.knative.pkg.apis.Condition;
import io.fabric8.knative.pkg.apis.ConditionBuilder;
import io.fabric8.knative.pkg.apis.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TriggerStatusFluent<A extends TriggerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Map<String, String> annotations;
    private AuthStatusBuilder auth;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private String deadLetterSinkAudience;
    private String deadLetterSinkCACerts;
    private String deadLetterSinkUri;
    private Long observedGeneration;
    private String subscriberAudience;
    private String subscriberCACerts;
    private String subscriberUri;

    public TriggerStatusFluent() {
    }

    public TriggerStatusFluent(TriggerStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public AuthStatus buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? TriggerStatusFluent.build(this.conditions) : null;
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(TriggerStatus instance) {
        TriggerStatus triggerStatus = instance = instance != null ? instance : new TriggerStatus();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withAuth(instance.getAuth());
            this.withConditions(instance.getConditions());
            this.withDeadLetterSinkAudience(instance.getDeadLetterSinkAudience());
            this.withDeadLetterSinkCACerts(instance.getDeadLetterSinkCACerts());
            this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withSubscriberAudience(instance.getSubscriberAudience());
            this.withSubscriberCACerts(instance.getSubscriberCACerts());
            this.withSubscriberUri(instance.getSubscriberUri());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthStatusBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(AuthStatus item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TriggerStatusFluent that = (TriggerStatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkAudience, that.deadLetterSinkAudience)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkCACerts, that.deadLetterSinkCACerts)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkUri, that.deadLetterSinkUri)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.subscriberAudience, that.subscriberAudience)) {
            return false;
        }
        if (!Objects.equals(this.subscriberCACerts, that.subscriberCACerts)) {
            return false;
        }
        if (!Objects.equals(this.subscriberUri, that.subscriberUri)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public String getDeadLetterSinkAudience() {
        return this.deadLetterSinkAudience;
    }

    public String getDeadLetterSinkCACerts() {
        return this.deadLetterSinkCACerts;
    }

    public String getDeadLetterSinkUri() {
        return this.deadLetterSinkUri;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public String getSubscriberAudience() {
        return this.subscriberAudience;
    }

    public String getSubscriberCACerts() {
        return this.subscriberCACerts;
    }

    public String getSubscriberUri() {
        return this.subscriberUri;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasDeadLetterSinkAudience() {
        return this.deadLetterSinkAudience != null;
    }

    public boolean hasDeadLetterSinkCACerts() {
        return this.deadLetterSinkCACerts != null;
    }

    public boolean hasDeadLetterSinkUri() {
        return this.deadLetterSinkUri != null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasSubscriberAudience() {
        return this.subscriberAudience != null;
    }

    public boolean hasSubscriberCACerts() {
        return this.subscriberCACerts != null;
    }

    public boolean hasSubscriberUri() {
        return this.subscriberUri != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.auth, this.conditions, this.deadLetterSinkAudience, this.deadLetterSinkCACerts, this.deadLetterSinkUri, this.observedGeneration, this.subscriberAudience, this.subscriberCACerts, this.subscriberUri, this.additionalProperties});
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations);
            sb.append(",");
        }
        if (this.auth != null) {
            sb.append("auth:");
            sb.append((Object)this.auth);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.deadLetterSinkAudience != null) {
            sb.append("deadLetterSinkAudience:");
            sb.append(this.deadLetterSinkAudience);
            sb.append(",");
        }
        if (this.deadLetterSinkCACerts != null) {
            sb.append("deadLetterSinkCACerts:");
            sb.append(this.deadLetterSinkCACerts);
            sb.append(",");
        }
        if (this.deadLetterSinkUri != null) {
            sb.append("deadLetterSinkUri:");
            sb.append(this.deadLetterSinkUri);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.subscriberAudience != null) {
            sb.append("subscriberAudience:");
            sb.append(this.subscriberAudience);
            sb.append(",");
        }
        if (this.subscriberCACerts != null) {
            sb.append("subscriberCACerts:");
            sb.append(this.subscriberCACerts);
            sb.append(",");
        }
        if (this.subscriberUri != null) {
            sb.append("subscriberUri:");
            sb.append(this.subscriberUri);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public A withAuth(AuthStatus auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthStatusBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withDeadLetterSinkAudience(String deadLetterSinkAudience) {
        this.deadLetterSinkAudience = deadLetterSinkAudience;
        return (A)((Object)this);
    }

    public A withDeadLetterSinkCACerts(String deadLetterSinkCACerts) {
        this.deadLetterSinkCACerts = deadLetterSinkCACerts;
        return (A)((Object)this);
    }

    public A withDeadLetterSinkUri(String deadLetterSinkUri) {
        this.deadLetterSinkUri = deadLetterSinkUri;
        return (A)((Object)this);
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(AuthStatus item) {
        return new AuthNested(item);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withSubscriberAudience(String subscriberAudience) {
        this.subscriberAudience = subscriberAudience;
        return (A)((Object)this);
    }

    public A withSubscriberCACerts(String subscriberCACerts) {
        this.subscriberCACerts = subscriberCACerts;
        return (A)((Object)this);
    }

    public A withSubscriberUri(String subscriberUri) {
        this.subscriberUri = subscriberUri;
        return (A)((Object)this);
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)TriggerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends AuthStatusFluent<AuthNested<N>>
    implements Nested<N> {
        AuthStatusBuilder builder;

        AuthNested(AuthStatus item) {
            this.builder = new AuthStatusBuilder(this, item);
        }

        public N and() {
            return (N)TriggerStatusFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }
}

