/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1;

import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.Auth;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.Secret;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.SecretBuilder;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.SecretFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AuthFluent<A extends AuthFluent<A>>
extends BaseFluent<A> {
    private String accessKey;
    private Map<String, Object> additionalProperties;
    private SecretBuilder secret;
    private String secretKey;

    public AuthFluent() {
    }

    public AuthFluent(Auth instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public Secret buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    protected void copyInstance(Auth instance) {
        Auth auth = instance = instance != null ? instance : new Auth();
        if (instance != null) {
            this.withAccessKey(instance.getAccessKey());
            this.withSecret(instance.getSecret());
            this.withSecretKey(instance.getSecretKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(new SecretBuilder().build()));
    }

    public SecretNested<A> editOrNewSecretLike(Secret item) {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(item));
    }

    public SecretNested<A> editSecret() {
        return this.withNewSecretLike(Optional.ofNullable(this.buildSecret()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthFluent that = (AuthFluent)((Object)o);
        if (!Objects.equals(this.accessKey, that.accessKey)) {
            return false;
        }
        if (!Objects.equals((Object)this.secret, (Object)that.secret)) {
            return false;
        }
        if (!Objects.equals(this.secretKey, that.secretKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean hasAccessKey() {
        return this.accessKey != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    public boolean hasSecretKey() {
        return this.secretKey != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessKey, this.secret, this.secretKey, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accessKey != null) {
            sb.append("accessKey:");
            sb.append(this.accessKey);
            sb.append(",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append((Object)this.secret);
            sb.append(",");
        }
        if (this.secretKey != null) {
            sb.append("secretKey:");
            sb.append(this.secretKey);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public SecretNested<A> withNewSecret() {
        return new SecretNested(null);
    }

    public SecretNested<A> withNewSecretLike(Secret item) {
        return new SecretNested(item);
    }

    public A withSecret(Secret secret) {
        this._visitables.remove((Object)"secret");
        if (secret != null) {
            this.secret = new SecretBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get((Object)"secret").remove((Object)this.secret);
        }
        return (A)((Object)this);
    }

    public A withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return (A)((Object)this);
    }

    public class SecretNested<N>
    extends SecretFluent<SecretNested<N>>
    implements Nested<N> {
        SecretBuilder builder;

        SecretNested(Secret item) {
            this.builder = new SecretBuilder(this, item);
        }

        public N and() {
            return (N)AuthFluent.this.withSecret(this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }
}

