/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.duck.v1;

import io.fabric8.knative.duck.v1.AuthStatus;
import io.fabric8.knative.duck.v1.AuthStatusBuilder;
import io.fabric8.knative.duck.v1.AuthStatusFluent;
import io.fabric8.knative.duck.v1.DeliverySpec;
import io.fabric8.knative.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.duck.v1.DeliverySpecFluent;
import io.fabric8.knative.duck.v1.SubscriberSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SubscriberSpecFluent<A extends SubscriberSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AuthStatusBuilder auth;
    private DeliverySpecBuilder delivery;
    private Long generation;
    private String name;
    private String replyAudience;
    private String replyCACerts;
    private String replyUri;
    private String subscriberAudience;
    private String subscriberCACerts;
    private String subscriberUri;
    private String uid;

    public SubscriberSpecFluent() {
    }

    public SubscriberSpecFluent(SubscriberSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public AuthStatus buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    protected void copyInstance(SubscriberSpec instance) {
        SubscriberSpec subscriberSpec = instance = instance != null ? instance : new SubscriberSpec();
        if (instance != null) {
            this.withAuth(instance.getAuth());
            this.withDelivery(instance.getDelivery());
            this.withGeneration(instance.getGeneration());
            this.withName(instance.getName());
            this.withReplyAudience(instance.getReplyAudience());
            this.withReplyCACerts(instance.getReplyCACerts());
            this.withReplyUri(instance.getReplyUri());
            this.withSubscriberAudience(instance.getSubscriberAudience());
            this.withSubscriberCACerts(instance.getSubscriberCACerts());
            this.withSubscriberUri(instance.getSubscriberUri());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(null));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthStatusBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(AuthStatus item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(new DeliverySpecBuilder().build()));
    }

    public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriberSpecFluent that = (SubscriberSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals((Object)this.delivery, (Object)that.delivery)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.replyAudience, that.replyAudience)) {
            return false;
        }
        if (!Objects.equals(this.replyCACerts, that.replyCACerts)) {
            return false;
        }
        if (!Objects.equals(this.replyUri, that.replyUri)) {
            return false;
        }
        if (!Objects.equals(this.subscriberAudience, that.subscriberAudience)) {
            return false;
        }
        if (!Objects.equals(this.subscriberCACerts, that.subscriberCACerts)) {
            return false;
        }
        if (!Objects.equals(this.subscriberUri, that.subscriberUri)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public String getName() {
        return this.name;
    }

    public String getReplyAudience() {
        return this.replyAudience;
    }

    public String getReplyCACerts() {
        return this.replyCACerts;
    }

    public String getReplyUri() {
        return this.replyUri;
    }

    public String getSubscriberAudience() {
        return this.subscriberAudience;
    }

    public String getSubscriberCACerts() {
        return this.subscriberCACerts;
    }

    public String getSubscriberUri() {
        return this.subscriberUri;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public boolean hasDelivery() {
        return this.delivery != null;
    }

    public boolean hasGeneration() {
        return this.generation != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasReplyAudience() {
        return this.replyAudience != null;
    }

    public boolean hasReplyCACerts() {
        return this.replyCACerts != null;
    }

    public boolean hasReplyUri() {
        return this.replyUri != null;
    }

    public boolean hasSubscriberAudience() {
        return this.subscriberAudience != null;
    }

    public boolean hasSubscriberCACerts() {
        return this.subscriberCACerts != null;
    }

    public boolean hasSubscriberUri() {
        return this.subscriberUri != null;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth, this.delivery, this.generation, this.name, this.replyAudience, this.replyCACerts, this.replyUri, this.subscriberAudience, this.subscriberCACerts, this.subscriberUri, this.uid, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auth != null) {
            sb.append("auth:");
            sb.append((Object)this.auth);
            sb.append(",");
        }
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append((Object)this.delivery);
            sb.append(",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.replyAudience != null) {
            sb.append("replyAudience:");
            sb.append(this.replyAudience);
            sb.append(",");
        }
        if (this.replyCACerts != null) {
            sb.append("replyCACerts:");
            sb.append(this.replyCACerts);
            sb.append(",");
        }
        if (this.replyUri != null) {
            sb.append("replyUri:");
            sb.append(this.replyUri);
            sb.append(",");
        }
        if (this.subscriberAudience != null) {
            sb.append("subscriberAudience:");
            sb.append(this.subscriberAudience);
            sb.append(",");
        }
        if (this.subscriberCACerts != null) {
            sb.append("subscriberCACerts:");
            sb.append(this.subscriberCACerts);
            sb.append(",");
        }
        if (this.subscriberUri != null) {
            sb.append("subscriberUri:");
            sb.append(this.subscriberUri);
            sb.append(",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAuth(AuthStatus auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthStatusBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public A withDelivery(DeliverySpec delivery) {
        this._visitables.remove((Object)"delivery");
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        }
        return (A)((Object)this);
    }

    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(AuthStatus item) {
        return new AuthNested(item);
    }

    public DeliveryNested<A> withNewDelivery() {
        return new DeliveryNested(null);
    }

    public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNested(item);
    }

    public A withReplyAudience(String replyAudience) {
        this.replyAudience = replyAudience;
        return (A)((Object)this);
    }

    public A withReplyCACerts(String replyCACerts) {
        this.replyCACerts = replyCACerts;
        return (A)((Object)this);
    }

    public A withReplyUri(String replyUri) {
        this.replyUri = replyUri;
        return (A)((Object)this);
    }

    public A withSubscriberAudience(String subscriberAudience) {
        this.subscriberAudience = subscriberAudience;
        return (A)((Object)this);
    }

    public A withSubscriberCACerts(String subscriberCACerts) {
        this.subscriberCACerts = subscriberCACerts;
        return (A)((Object)this);
    }

    public A withSubscriberUri(String subscriberUri) {
        this.subscriberUri = subscriberUri;
        return (A)((Object)this);
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public class DeliveryNested<N>
    extends DeliverySpecFluent<DeliveryNested<N>>
    implements Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNested(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        public N and() {
            return (N)SubscriberSpecFluent.this.withDelivery(this.builder.build());
        }

        public N endDelivery() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends AuthStatusFluent<AuthNested<N>>
    implements Nested<N> {
        AuthStatusBuilder builder;

        AuthNested(AuthStatus item) {
            this.builder = new AuthStatusBuilder(this, item);
        }

        public N and() {
            return (N)SubscriberSpecFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }
}

