/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.knative.duck.v1.DeliverySpec;
import io.fabric8.knative.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.duck.v1.DeliverySpecFluent;
import io.fabric8.knative.duck.v1.KReference;
import io.fabric8.knative.duck.v1.KReferenceBuilder;
import io.fabric8.knative.duck.v1.KReferenceFluent;
import io.fabric8.knative.eventing.v1alpha1.RequestReplySpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RequestReplySpecFluent<A extends RequestReplySpecFluent<A>>
extends BaseFluent<A> {
    private KReferenceBuilder brokerRef;
    private String correlationAttribute;
    private DeliverySpecBuilder delivery;
    private String replyAttribute;
    private List<String> secrets = new ArrayList<String>();
    private String timeout;
    private Map<String, Object> additionalProperties;

    public RequestReplySpecFluent() {
    }

    public RequestReplySpecFluent(RequestReplySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RequestReplySpec instance) {
        RequestReplySpec requestReplySpec = instance = instance != null ? instance : new RequestReplySpec();
        if (instance != null) {
            this.withBrokerRef(instance.getBrokerRef());
            this.withCorrelationAttribute(instance.getCorrelationAttribute());
            this.withDelivery(instance.getDelivery());
            this.withReplyAttribute(instance.getReplyAttribute());
            this.withSecrets(instance.getSecrets());
            this.withTimeout(instance.getTimeout());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public KReference buildBrokerRef() {
        return this.brokerRef != null ? this.brokerRef.build() : null;
    }

    public A withBrokerRef(KReference brokerRef) {
        this._visitables.remove((Object)"brokerRef");
        if (brokerRef != null) {
            this.brokerRef = new KReferenceBuilder(brokerRef);
            this._visitables.get((Object)"brokerRef").add(this.brokerRef);
        } else {
            this.brokerRef = null;
            this._visitables.get((Object)"brokerRef").remove((Object)this.brokerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasBrokerRef() {
        return this.brokerRef != null;
    }

    public BrokerRefNested<A> withNewBrokerRef() {
        return new BrokerRefNested(null);
    }

    public BrokerRefNested<A> withNewBrokerRefLike(KReference item) {
        return new BrokerRefNested(item);
    }

    public BrokerRefNested<A> editBrokerRef() {
        return this.withNewBrokerRefLike(Optional.ofNullable(this.buildBrokerRef()).orElse(null));
    }

    public BrokerRefNested<A> editOrNewBrokerRef() {
        return this.withNewBrokerRefLike(Optional.ofNullable(this.buildBrokerRef()).orElse(new KReferenceBuilder().build()));
    }

    public BrokerRefNested<A> editOrNewBrokerRefLike(KReference item) {
        return this.withNewBrokerRefLike(Optional.ofNullable(this.buildBrokerRef()).orElse(item));
    }

    public String getCorrelationAttribute() {
        return this.correlationAttribute;
    }

    public A withCorrelationAttribute(String correlationAttribute) {
        this.correlationAttribute = correlationAttribute;
        return (A)((Object)this);
    }

    public boolean hasCorrelationAttribute() {
        return this.correlationAttribute != null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    public A withDelivery(DeliverySpec delivery) {
        this._visitables.remove((Object)"delivery");
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        }
        return (A)((Object)this);
    }

    public boolean hasDelivery() {
        return this.delivery != null;
    }

    public DeliveryNested<A> withNewDelivery() {
        return new DeliveryNested(null);
    }

    public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNested(item);
    }

    public DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(null));
    }

    public DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(new DeliverySpecBuilder().build()));
    }

    public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(item));
    }

    public String getReplyAttribute() {
        return this.replyAttribute;
    }

    public A withReplyAttribute(String replyAttribute) {
        this.replyAttribute = replyAttribute;
        return (A)((Object)this);
    }

    public boolean hasReplyAttribute() {
        return this.replyAttribute != null;
    }

    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)((Object)this);
    }

    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)((Object)this);
    }

    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSecrets(String ... items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecrets(Collection<String> items) {
        if (this.secrets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<String> secrets) {
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)((Object)this);
    }

    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove((Object)"secrets");
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestReplySpecFluent that = (RequestReplySpecFluent)((Object)o);
        if (!Objects.equals((Object)this.brokerRef, (Object)that.brokerRef)) {
            return false;
        }
        if (!Objects.equals(this.correlationAttribute, that.correlationAttribute)) {
            return false;
        }
        if (!Objects.equals((Object)this.delivery, (Object)that.delivery)) {
            return false;
        }
        if (!Objects.equals(this.replyAttribute, that.replyAttribute)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brokerRef, this.correlationAttribute, this.delivery, this.replyAttribute, this.secrets, this.timeout, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.brokerRef != null) {
            sb.append("brokerRef:");
            sb.append(String.valueOf((Object)this.brokerRef) + ",");
        }
        if (this.correlationAttribute != null) {
            sb.append("correlationAttribute:");
            sb.append(this.correlationAttribute + ",");
        }
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append(String.valueOf((Object)this.delivery) + ",");
        }
        if (this.replyAttribute != null) {
            sb.append("replyAttribute:");
            sb.append(this.replyAttribute + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(String.valueOf(this.secrets) + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeliveryNested<N>
    extends DeliverySpecFluent<DeliveryNested<N>>
    implements Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNested(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        public N and() {
            return (N)RequestReplySpecFluent.this.withDelivery(this.builder.build());
        }

        public N endDelivery() {
            return this.and();
        }
    }

    public class BrokerRefNested<N>
    extends KReferenceFluent<BrokerRefNested<N>>
    implements Nested<N> {
        KReferenceBuilder builder;

        BrokerRefNested(KReference item) {
            this.builder = new KReferenceBuilder(this, item);
        }

        public N and() {
            return (N)RequestReplySpecFluent.this.withBrokerRef(this.builder.build());
        }

        public N endBrokerRef() {
            return this.and();
        }
    }
}

