/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sinks.v1alpha1;

import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSS3;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSS3Builder;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSS3Fluent;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSSNS;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSSNSBuilder;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSSNSFluent;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSSQS;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSSQSBuilder;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AWSSQSFluent;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.Auth;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AuthBuilder;
import io.fabric8.knative.eventing.pkg.apis.common.integration.v1alpha1.AuthFluent;
import io.fabric8.knative.sinks.v1alpha1.Aws;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AwsFluent<A extends AwsFluent<A>>
extends BaseFluent<A> {
    private AuthBuilder auth;
    private AWSS3Builder s3;
    private AWSSNSBuilder sns;
    private AWSSQSBuilder sqs;
    private Map<String, Object> additionalProperties;

    public AwsFluent() {
    }

    public AwsFluent(Aws instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Aws instance) {
        Aws aws = instance = instance != null ? instance : new Aws();
        if (instance != null) {
            this.withAuth(instance.getAuth());
            this.withS3(instance.getS3());
            this.withSns(instance.getSns());
            this.withSqs(instance.getSqs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Auth buildAuth() {
        return this.auth != null ? this.auth.build() : null;
    }

    public A withAuth(Auth auth) {
        this._visitables.remove((Object)"auth");
        if (auth != null) {
            this.auth = new AuthBuilder(auth);
            this._visitables.get((Object)"auth").add(this.auth);
        } else {
            this.auth = null;
            this._visitables.get((Object)"auth").remove((Object)this.auth);
        }
        return (A)((Object)this);
    }

    public boolean hasAuth() {
        return this.auth != null;
    }

    public AuthNested<A> withNewAuth() {
        return new AuthNested(null);
    }

    public AuthNested<A> withNewAuthLike(Auth item) {
        return new AuthNested(item);
    }

    public AuthNested<A> editAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(null));
    }

    public AuthNested<A> editOrNewAuth() {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(new AuthBuilder().build()));
    }

    public AuthNested<A> editOrNewAuthLike(Auth item) {
        return this.withNewAuthLike(Optional.ofNullable(this.buildAuth()).orElse(item));
    }

    public AWSS3 buildS3() {
        return this.s3 != null ? this.s3.build() : null;
    }

    public A withS3(AWSS3 s3) {
        this._visitables.remove((Object)"s3");
        if (s3 != null) {
            this.s3 = new AWSS3Builder(s3);
            this._visitables.get((Object)"s3").add(this.s3);
        } else {
            this.s3 = null;
            this._visitables.get((Object)"s3").remove((Object)this.s3);
        }
        return (A)((Object)this);
    }

    public boolean hasS3() {
        return this.s3 != null;
    }

    public S3Nested<A> withNewS3() {
        return new S3Nested(null);
    }

    public S3Nested<A> withNewS3Like(AWSS3 item) {
        return new S3Nested(item);
    }

    public S3Nested<A> editS3() {
        return this.withNewS3Like(Optional.ofNullable(this.buildS3()).orElse(null));
    }

    public S3Nested<A> editOrNewS3() {
        return this.withNewS3Like(Optional.ofNullable(this.buildS3()).orElse(new AWSS3Builder().build()));
    }

    public S3Nested<A> editOrNewS3Like(AWSS3 item) {
        return this.withNewS3Like(Optional.ofNullable(this.buildS3()).orElse(item));
    }

    public AWSSNS buildSns() {
        return this.sns != null ? this.sns.build() : null;
    }

    public A withSns(AWSSNS sns) {
        this._visitables.remove((Object)"sns");
        if (sns != null) {
            this.sns = new AWSSNSBuilder(sns);
            this._visitables.get((Object)"sns").add(this.sns);
        } else {
            this.sns = null;
            this._visitables.get((Object)"sns").remove((Object)this.sns);
        }
        return (A)((Object)this);
    }

    public boolean hasSns() {
        return this.sns != null;
    }

    public A withNewSns(String arn, Boolean autoCreateTopic, Boolean overrideEndpoint, String region, String uriEndpointOverride) {
        return this.withSns(new AWSSNS(arn, autoCreateTopic, overrideEndpoint, region, uriEndpointOverride));
    }

    public SnsNested<A> withNewSns() {
        return new SnsNested(null);
    }

    public SnsNested<A> withNewSnsLike(AWSSNS item) {
        return new SnsNested(item);
    }

    public SnsNested<A> editSns() {
        return this.withNewSnsLike(Optional.ofNullable(this.buildSns()).orElse(null));
    }

    public SnsNested<A> editOrNewSns() {
        return this.withNewSnsLike(Optional.ofNullable(this.buildSns()).orElse(new AWSSNSBuilder().build()));
    }

    public SnsNested<A> editOrNewSnsLike(AWSSNS item) {
        return this.withNewSnsLike(Optional.ofNullable(this.buildSns()).orElse(item));
    }

    public AWSSQS buildSqs() {
        return this.sqs != null ? this.sqs.build() : null;
    }

    public A withSqs(AWSSQS sqs) {
        this._visitables.remove((Object)"sqs");
        if (sqs != null) {
            this.sqs = new AWSSQSBuilder(sqs);
            this._visitables.get((Object)"sqs").add(this.sqs);
        } else {
            this.sqs = null;
            this._visitables.get((Object)"sqs").remove((Object)this.sqs);
        }
        return (A)((Object)this);
    }

    public boolean hasSqs() {
        return this.sqs != null;
    }

    public SqsNested<A> withNewSqs() {
        return new SqsNested(null);
    }

    public SqsNested<A> withNewSqsLike(AWSSQS item) {
        return new SqsNested(item);
    }

    public SqsNested<A> editSqs() {
        return this.withNewSqsLike(Optional.ofNullable(this.buildSqs()).orElse(null));
    }

    public SqsNested<A> editOrNewSqs() {
        return this.withNewSqsLike(Optional.ofNullable(this.buildSqs()).orElse(new AWSSQSBuilder().build()));
    }

    public SqsNested<A> editOrNewSqsLike(AWSSQS item) {
        return this.withNewSqsLike(Optional.ofNullable(this.buildSqs()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AwsFluent that = (AwsFluent)((Object)o);
        if (!Objects.equals((Object)this.auth, (Object)that.auth)) {
            return false;
        }
        if (!Objects.equals((Object)this.s3, (Object)that.s3)) {
            return false;
        }
        if (!Objects.equals((Object)this.sns, (Object)that.sns)) {
            return false;
        }
        if (!Objects.equals((Object)this.sqs, (Object)that.sqs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.auth, this.s3, this.sns, this.sqs, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.auth != null) {
            sb.append("auth:");
            sb.append(this.auth + ",");
        }
        if (this.s3 != null) {
            sb.append("s3:");
            sb.append(this.s3 + ",");
        }
        if (this.sns != null) {
            sb.append("sns:");
            sb.append(this.sns + ",");
        }
        if (this.sqs != null) {
            sb.append("sqs:");
            sb.append(this.sqs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SqsNested<N>
    extends AWSSQSFluent<SqsNested<N>>
    implements Nested<N> {
        AWSSQSBuilder builder;

        SqsNested(AWSSQS item) {
            this.builder = new AWSSQSBuilder(this, item);
        }

        public N and() {
            return (N)AwsFluent.this.withSqs(this.builder.build());
        }

        public N endSqs() {
            return this.and();
        }
    }

    public class SnsNested<N>
    extends AWSSNSFluent<SnsNested<N>>
    implements Nested<N> {
        AWSSNSBuilder builder;

        SnsNested(AWSSNS item) {
            this.builder = new AWSSNSBuilder(this, item);
        }

        public N and() {
            return (N)AwsFluent.this.withSns(this.builder.build());
        }

        public N endSns() {
            return this.and();
        }
    }

    public class S3Nested<N>
    extends AWSS3Fluent<S3Nested<N>>
    implements Nested<N> {
        AWSS3Builder builder;

        S3Nested(AWSS3 item) {
            this.builder = new AWSS3Builder(this, item);
        }

        public N and() {
            return (N)AwsFluent.this.withS3(this.builder.build());
        }

        public N endS3() {
            return this.and();
        }
    }

    public class AuthNested<N>
    extends AuthFluent<AuthNested<N>>
    implements Nested<N> {
        AuthBuilder builder;

        AuthNested(Auth item) {
            this.builder = new AuthBuilder(this, item);
        }

        public N and() {
            return (N)AwsFluent.this.withAuth(this.builder.build());
        }

        public N endAuth() {
            return this.and();
        }
    }
}

