/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.RevisionTemplateSpec;
import io.fabric8.knative.serving.v1.RevisionTemplateSpecBuilder;
import io.fabric8.knative.serving.v1.RevisionTemplateSpecFluent;
import io.fabric8.knative.serving.v1.ServiceSpec;
import io.fabric8.knative.serving.v1.TrafficTarget;
import io.fabric8.knative.serving.v1.TrafficTargetBuilder;
import io.fabric8.knative.serving.v1.TrafficTargetFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ServiceSpecFluent<A extends ServiceSpecFluent<A>>
extends BaseFluent<A> {
    private RevisionTemplateSpecBuilder template;
    private ArrayList<TrafficTargetBuilder> traffic = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ServiceSpecFluent() {
    }

    public ServiceSpecFluent(ServiceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceSpec instance) {
        ServiceSpec serviceSpec = instance = instance != null ? instance : new ServiceSpec();
        if (instance != null) {
            this.withTemplate(instance.getTemplate());
            this.withTraffic(instance.getTraffic());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RevisionTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(RevisionTemplateSpec template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new RevisionTemplateSpecBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(RevisionTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new RevisionTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(RevisionTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public A addToTraffic(int index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= this.traffic.size()) {
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        } else {
            this._visitables.get((Object)"traffic").add(index, builder);
            this.traffic.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTraffic(int index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= this.traffic.size()) {
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        } else {
            this._visitables.get((Object)"traffic").set(index, builder);
            this.traffic.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTraffic(TrafficTarget ... items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTraffic(TrafficTarget ... items) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove((Object)builder);
            this.traffic.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove((Object)builder);
            this.traffic.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        Iterator<TrafficTargetBuilder> each = this.traffic.iterator();
        List visitables = this._visitables.get((Object)"traffic");
        while (each.hasNext()) {
            TrafficTargetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TrafficTarget> buildTraffic() {
        return this.traffic != null ? ServiceSpecFluent.build(this.traffic) : null;
    }

    public TrafficTarget buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    public TrafficTarget buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    public TrafficTarget buildLastTraffic() {
        return this.traffic.get(this.traffic.size() - 1).build();
    }

    public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTraffic(List<TrafficTarget> traffic) {
        if (this.traffic != null) {
            this._visitables.get((Object)"traffic").clear();
        }
        if (traffic != null) {
            this.traffic = new ArrayList();
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        } else {
            this.traffic = null;
        }
        return (A)((Object)this);
    }

    public A withTraffic(TrafficTarget ... traffic) {
        if (this.traffic != null) {
            this.traffic.clear();
            this._visitables.remove((Object)"traffic");
        }
        if (traffic != null) {
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTraffic() {
        return this.traffic != null && !this.traffic.isEmpty();
    }

    public TrafficNested<A> addNewTraffic() {
        return new TrafficNested(-1, null);
    }

    public TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
        return new TrafficNested(-1, item);
    }

    public TrafficNested<A> setNewTrafficLike(int index, TrafficTarget item) {
        return new TrafficNested(index, item);
    }

    public TrafficNested<A> editTraffic(int index) {
        if (this.traffic.size() <= index) {
            throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public TrafficNested<A> editFirstTraffic() {
        if (this.traffic.size() == 0) {
            throw new RuntimeException("Can't edit first traffic. The list is empty.");
        }
        return this.setNewTrafficLike(0, this.buildTraffic(0));
    }

    public TrafficNested<A> editLastTraffic() {
        int index = this.traffic.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last traffic. The list is empty.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.traffic.size(); ++i) {
            if (!predicate.test(this.traffic.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching traffic. No match found.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceSpecFluent that = (ServiceSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        if (!Objects.equals(this.traffic, that.traffic)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.template, this.traffic, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.traffic != null && !this.traffic.isEmpty()) {
            sb.append("traffic:");
            sb.append(this.traffic + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TrafficNested<N>
    extends TrafficTargetFluent<TrafficNested<N>>
    implements Nested<N> {
        TrafficTargetBuilder builder;
        int index;

        TrafficNested(int index, TrafficTarget item) {
            this.index = index;
            this.builder = new TrafficTargetBuilder(this, item);
        }

        public N and() {
            return (N)ServiceSpecFluent.this.setToTraffic(this.index, this.builder.build());
        }

        public N endTraffic() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends RevisionTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        RevisionTemplateSpecBuilder builder;

        TemplateNested(RevisionTemplateSpec item) {
            this.builder = new RevisionTemplateSpecBuilder(this, item);
        }

        public N and() {
            return (N)ServiceSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

