/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.knative.internal.networking.v1alpha1.ServerlessServiceSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.Objects;
import java.util.Optional;

public class ServerlessServiceSpecFluent<A extends ServerlessServiceSpecFluent<A>>
extends BaseFluent<A> {
    private String mode;
    private Integer numActivators;
    private ObjectReferenceBuilder objectRef;
    private String protocolType;

    public ServerlessServiceSpecFluent() {
    }

    public ServerlessServiceSpecFluent(ServerlessServiceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServerlessServiceSpec instance) {
        ServerlessServiceSpec serverlessServiceSpec = instance = instance != null ? instance : new ServerlessServiceSpec();
        if (instance != null) {
            this.withMode(instance.getMode());
            this.withNumActivators(instance.getNumActivators());
            this.withObjectRef(instance.getObjectRef());
            this.withProtocolType(instance.getProtocolType());
            this.withMode(instance.getMode());
            this.withNumActivators(instance.getNumActivators());
            this.withObjectRef(instance.getObjectRef());
            this.withProtocolType(instance.getProtocolType());
        }
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode = mode;
        return (A)((Object)this);
    }

    public boolean hasMode() {
        return this.mode != null;
    }

    public Integer getNumActivators() {
        return this.numActivators;
    }

    public A withNumActivators(Integer numActivators) {
        this.numActivators = numActivators;
        return (A)((Object)this);
    }

    public boolean hasNumActivators() {
        return this.numActivators != null;
    }

    public ObjectReference buildObjectRef() {
        return this.objectRef != null ? this.objectRef.build() : null;
    }

    public A withObjectRef(ObjectReference objectRef) {
        this._visitables.remove((Object)this.objectRef);
        if (objectRef != null) {
            this.objectRef = new ObjectReferenceBuilder(objectRef);
            this._visitables.get((Object)"objectRef").add(this.objectRef);
        } else {
            this.objectRef = null;
            this._visitables.get((Object)"objectRef").remove(this.objectRef);
        }
        return (A)((Object)this);
    }

    public boolean hasObjectRef() {
        return this.objectRef != null;
    }

    public ObjectRefNested<A> withNewObjectRef() {
        return new ObjectRefNested(null);
    }

    public ObjectRefNested<A> withNewObjectRefLike(ObjectReference item) {
        return new ObjectRefNested(item);
    }

    public ObjectRefNested<A> editObjectRef() {
        return this.withNewObjectRefLike(Optional.ofNullable(this.buildObjectRef()).orElse(null));
    }

    public ObjectRefNested<A> editOrNewObjectRef() {
        return this.withNewObjectRefLike(Optional.ofNullable(this.buildObjectRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ObjectRefNested<A> editOrNewObjectRefLike(ObjectReference item) {
        return this.withNewObjectRefLike(Optional.ofNullable(this.buildObjectRef()).orElse(item));
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public A withProtocolType(String protocolType) {
        this.protocolType = protocolType;
        return (A)((Object)this);
    }

    public boolean hasProtocolType() {
        return this.protocolType != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerlessServiceSpecFluent that = (ServerlessServiceSpecFluent)((Object)o);
        if (!Objects.equals(this.mode, that.mode)) {
            return false;
        }
        if (!Objects.equals(this.numActivators, that.numActivators)) {
            return false;
        }
        if (!Objects.equals(this.objectRef, that.objectRef)) {
            return false;
        }
        return Objects.equals(this.protocolType, that.protocolType);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.numActivators, this.objectRef, this.protocolType, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mode != null) {
            sb.append("mode:");
            sb.append(this.mode + ",");
        }
        if (this.numActivators != null) {
            sb.append("numActivators:");
            sb.append(this.numActivators + ",");
        }
        if (this.objectRef != null) {
            sb.append("objectRef:");
            sb.append(this.objectRef + ",");
        }
        if (this.protocolType != null) {
            sb.append("protocolType:");
            sb.append(this.protocolType);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ObjectRefNested<N>
    extends ObjectReferenceFluent<ObjectRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ObjectRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)ServerlessServiceSpecFluent.this.withObjectRef(this.builder.build());
        }

        public N endObjectRef() {
            return this.and();
        }
    }
}

