/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.internal.networking.v1alpha1;

import io.fabric8.knative.internal.networking.v1alpha1.IngressStatus;
import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerStatus;
import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerStatusBuilder;
import io.fabric8.knative.internal.networking.v1alpha1.LoadBalancerStatusFluent;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class IngressStatusFluent<A extends IngressStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private LoadBalancerStatusBuilder privateLoadBalancer;
    private LoadBalancerStatusBuilder publicLoadBalancer;

    public IngressStatusFluent() {
    }

    public IngressStatusFluent(IngressStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressStatus instance) {
        IngressStatus ingressStatus = instance = instance != null ? instance : new IngressStatus();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPrivateLoadBalancer(instance.getPrivateLoadBalancer());
            this.withPublicLoadBalancer(instance.getPublicLoadBalancer());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPrivateLoadBalancer(instance.getPrivateLoadBalancer());
            this.withPublicLoadBalancer(instance.getPublicLoadBalancer());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? IngressStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public LoadBalancerStatus buildPrivateLoadBalancer() {
        return this.privateLoadBalancer != null ? this.privateLoadBalancer.build() : null;
    }

    public A withPrivateLoadBalancer(LoadBalancerStatus privateLoadBalancer) {
        this._visitables.remove((Object)this.privateLoadBalancer);
        if (privateLoadBalancer != null) {
            this.privateLoadBalancer = new LoadBalancerStatusBuilder(privateLoadBalancer);
            this._visitables.get((Object)"privateLoadBalancer").add(this.privateLoadBalancer);
        } else {
            this.privateLoadBalancer = null;
            this._visitables.get((Object)"privateLoadBalancer").remove((Object)this.privateLoadBalancer);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateLoadBalancer() {
        return this.privateLoadBalancer != null;
    }

    public PrivateLoadBalancerNested<A> withNewPrivateLoadBalancer() {
        return new PrivateLoadBalancerNested(null);
    }

    public PrivateLoadBalancerNested<A> withNewPrivateLoadBalancerLike(LoadBalancerStatus item) {
        return new PrivateLoadBalancerNested(item);
    }

    public PrivateLoadBalancerNested<A> editPrivateLoadBalancer() {
        return this.withNewPrivateLoadBalancerLike(Optional.ofNullable(this.buildPrivateLoadBalancer()).orElse(null));
    }

    public PrivateLoadBalancerNested<A> editOrNewPrivateLoadBalancer() {
        return this.withNewPrivateLoadBalancerLike(Optional.ofNullable(this.buildPrivateLoadBalancer()).orElse(new LoadBalancerStatusBuilder().build()));
    }

    public PrivateLoadBalancerNested<A> editOrNewPrivateLoadBalancerLike(LoadBalancerStatus item) {
        return this.withNewPrivateLoadBalancerLike(Optional.ofNullable(this.buildPrivateLoadBalancer()).orElse(item));
    }

    public LoadBalancerStatus buildPublicLoadBalancer() {
        return this.publicLoadBalancer != null ? this.publicLoadBalancer.build() : null;
    }

    public A withPublicLoadBalancer(LoadBalancerStatus publicLoadBalancer) {
        this._visitables.remove((Object)this.publicLoadBalancer);
        if (publicLoadBalancer != null) {
            this.publicLoadBalancer = new LoadBalancerStatusBuilder(publicLoadBalancer);
            this._visitables.get((Object)"publicLoadBalancer").add(this.publicLoadBalancer);
        } else {
            this.publicLoadBalancer = null;
            this._visitables.get((Object)"publicLoadBalancer").remove((Object)this.publicLoadBalancer);
        }
        return (A)((Object)this);
    }

    public boolean hasPublicLoadBalancer() {
        return this.publicLoadBalancer != null;
    }

    public PublicLoadBalancerNested<A> withNewPublicLoadBalancer() {
        return new PublicLoadBalancerNested(null);
    }

    public PublicLoadBalancerNested<A> withNewPublicLoadBalancerLike(LoadBalancerStatus item) {
        return new PublicLoadBalancerNested(item);
    }

    public PublicLoadBalancerNested<A> editPublicLoadBalancer() {
        return this.withNewPublicLoadBalancerLike(Optional.ofNullable(this.buildPublicLoadBalancer()).orElse(null));
    }

    public PublicLoadBalancerNested<A> editOrNewPublicLoadBalancer() {
        return this.withNewPublicLoadBalancerLike(Optional.ofNullable(this.buildPublicLoadBalancer()).orElse(new LoadBalancerStatusBuilder().build()));
    }

    public PublicLoadBalancerNested<A> editOrNewPublicLoadBalancerLike(LoadBalancerStatus item) {
        return this.withNewPublicLoadBalancerLike(Optional.ofNullable(this.buildPublicLoadBalancer()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressStatusFluent that = (IngressStatusFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateLoadBalancer, (Object)that.privateLoadBalancer)) {
            return false;
        }
        return Objects.equals((Object)this.publicLoadBalancer, (Object)that.publicLoadBalancer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.conditions, this.observedGeneration, this.privateLoadBalancer, this.publicLoadBalancer, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.privateLoadBalancer != null) {
            sb.append("privateLoadBalancer:");
            sb.append((Object)((Object)this.privateLoadBalancer) + ",");
        }
        if (this.publicLoadBalancer != null) {
            sb.append("publicLoadBalancer:");
            sb.append((Object)this.publicLoadBalancer);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PublicLoadBalancerNested<N>
    extends LoadBalancerStatusFluent<PublicLoadBalancerNested<N>>
    implements Nested<N> {
        LoadBalancerStatusBuilder builder;

        PublicLoadBalancerNested(LoadBalancerStatus item) {
            this.builder = new LoadBalancerStatusBuilder(this, item);
        }

        public N and() {
            return (N)IngressStatusFluent.this.withPublicLoadBalancer(this.builder.build());
        }

        public N endPublicLoadBalancer() {
            return this.and();
        }
    }

    public class PrivateLoadBalancerNested<N>
    extends LoadBalancerStatusFluent<PrivateLoadBalancerNested<N>>
    implements Nested<N> {
        LoadBalancerStatusBuilder builder;

        PrivateLoadBalancerNested(LoadBalancerStatus item) {
            this.builder = new LoadBalancerStatusBuilder(this, item);
        }

        public N and() {
            return (N)IngressStatusFluent.this.withPrivateLoadBalancer(this.builder.build());
        }

        public N endPrivateLoadBalancer() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)IngressStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

