/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluent;
import io.fabric8.knative.serving.v1.RouteStatus;
import io.fabric8.knative.serving.v1.TrafficTarget;
import io.fabric8.knative.serving.v1.TrafficTargetBuilder;
import io.fabric8.knative.serving.v1.TrafficTargetFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RouteStatusFluent<A extends RouteStatusFluent<A>>
extends BaseFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private Long observedGeneration;
    private ArrayList<TrafficTargetBuilder> traffic = new ArrayList();
    private String url;

    public RouteStatusFluent() {
    }

    public RouteStatusFluent(RouteStatus instance) {
        RouteStatus routeStatus = instance = instance != null ? instance : new RouteStatus();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withTraffic(instance.getTraffic());
            this.withUrl(instance.getUrl());
            this.withAddress(instance.getAddress());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withTraffic(instance.getTraffic());
            this.withUrl(instance.getUrl());
        }
    }

    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove((Object)this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove((Object)this.address);
        }
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String cACerts, String name, String url) {
        return this.withAddress(new Addressable(cACerts, name, url));
    }

    public AddressNested<A> withNewAddress() {
        return new AddressNested(null);
    }

    public AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNested(item);
    }

    public AddressNested<A> editAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(null));
    }

    public AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(new AddressableBuilder().build()));
    }

    public AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(Optional.ofNullable(this.buildAddress()).orElse(item));
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? RouteStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToTraffic(int index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= this.traffic.size()) {
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        } else {
            this._visitables.get((Object)"traffic").add(index, builder);
            this.traffic.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTraffic(int index, TrafficTarget item) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
        if (index < 0 || index >= this.traffic.size()) {
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        } else {
            this._visitables.get((Object)"traffic").set(index, builder);
            this.traffic.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTraffic(TrafficTarget ... items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {
            this.traffic = new ArrayList();
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").add(builder);
            this.traffic.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTraffic(TrafficTarget ... items) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove((Object)builder);
            this.traffic.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTraffic(Collection<TrafficTarget> items) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        for (TrafficTarget item : items) {
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            this._visitables.get((Object)"traffic").remove((Object)builder);
            this.traffic.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTraffic(Predicate<TrafficTargetBuilder> predicate) {
        if (this.traffic == null) {
            return (A)((Object)this);
        }
        Iterator<TrafficTargetBuilder> each = this.traffic.iterator();
        List visitables = this._visitables.get((Object)"traffic");
        while (each.hasNext()) {
            TrafficTargetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TrafficTarget> buildTraffic() {
        return this.traffic != null ? RouteStatusFluent.build(this.traffic) : null;
    }

    public TrafficTarget buildTraffic(int index) {
        return this.traffic.get(index).build();
    }

    public TrafficTarget buildFirstTraffic() {
        return this.traffic.get(0).build();
    }

    public TrafficTarget buildLastTraffic() {
        return this.traffic.get(this.traffic.size() - 1).build();
    }

    public TrafficTarget buildMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        for (TrafficTargetBuilder item : this.traffic) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTraffic(List<TrafficTarget> traffic) {
        if (this.traffic != null) {
            this._visitables.get((Object)"traffic").clear();
        }
        if (traffic != null) {
            this.traffic = new ArrayList();
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        } else {
            this.traffic = null;
        }
        return (A)((Object)this);
    }

    public A withTraffic(TrafficTarget ... traffic) {
        if (this.traffic != null) {
            this.traffic.clear();
            this._visitables.remove((Object)"traffic");
        }
        if (traffic != null) {
            for (TrafficTarget item : traffic) {
                this.addToTraffic(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTraffic() {
        return this.traffic != null && !this.traffic.isEmpty();
    }

    public TrafficNested<A> addNewTraffic() {
        return new TrafficNested(-1, null);
    }

    public TrafficNested<A> addNewTrafficLike(TrafficTarget item) {
        return new TrafficNested(-1, item);
    }

    public TrafficNested<A> setNewTrafficLike(int index, TrafficTarget item) {
        return new TrafficNested(index, item);
    }

    public TrafficNested<A> editTraffic(int index) {
        if (this.traffic.size() <= index) {
            throw new RuntimeException("Can't edit traffic. Index exceeds size.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public TrafficNested<A> editFirstTraffic() {
        if (this.traffic.size() == 0) {
            throw new RuntimeException("Can't edit first traffic. The list is empty.");
        }
        return this.setNewTrafficLike(0, this.buildTraffic(0));
    }

    public TrafficNested<A> editLastTraffic() {
        int index = this.traffic.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last traffic. The list is empty.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public TrafficNested<A> editMatchingTraffic(Predicate<TrafficTargetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.traffic.size(); ++i) {
            if (!predicate.test(this.traffic.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching traffic. No match found.");
        }
        return this.setNewTrafficLike(index, this.buildTraffic(index));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusFluent that = (RouteStatusFluent)((Object)o);
        if (!Objects.equals((Object)this.address, (Object)that.address)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.traffic, that.traffic)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.annotations, this.conditions, this.observedGeneration, this.traffic, this.url, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append((Object)((Object)this.address) + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.traffic != null && !this.traffic.isEmpty()) {
            sb.append("traffic:");
            sb.append(this.traffic + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TrafficNested<N>
    extends TrafficTargetFluent<TrafficNested<N>>
    implements Nested<N> {
        TrafficTargetBuilder builder;
        int index;

        TrafficNested(int index, TrafficTarget item) {
            this.index = index;
            this.builder = new TrafficTargetBuilder(this, item);
        }

        public N and() {
            return (N)RouteStatusFluent.this.setToTraffic(this.index, this.builder.build());
        }

        public N endTraffic() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        public N and() {
            return (N)RouteStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class AddressNested<N>
    extends AddressableFluent<AddressNested<N>>
    implements Nested<N> {
        AddressableBuilder builder;

        AddressNested(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        public N and() {
            return (N)RouteStatusFluent.this.withAddress(this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

