/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter;
import io.fabric8.knative.eventing.v1.SubscriptionsAPIFilterBuilder;
import io.fabric8.knative.eventing.v1.SubscriptionsAPIFilterFluent;
import io.fabric8.knative.eventing.v1.TriggerFilter;
import io.fabric8.knative.eventing.v1.TriggerFilterBuilder;
import io.fabric8.knative.eventing.v1.TriggerFilterFluent;
import io.fabric8.knative.eventing.v1.TriggerSpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TriggerSpecFluent<A extends TriggerSpecFluent<A>>
extends BaseFluent<A> {
    private String broker;
    private DeliverySpecBuilder delivery;
    private TriggerFilterBuilder filter;
    private ArrayList<SubscriptionsAPIFilterBuilder> filters = new ArrayList();
    private DestinationBuilder subscriber;

    public TriggerSpecFluent() {
    }

    public TriggerSpecFluent(TriggerSpec instance) {
        TriggerSpec triggerSpec = instance = instance != null ? instance : new TriggerSpec();
        if (instance != null) {
            this.withBroker(instance.getBroker());
            this.withDelivery(instance.getDelivery());
            this.withFilter(instance.getFilter());
            this.withFilters(instance.getFilters());
            this.withSubscriber(instance.getSubscriber());
            this.withBroker(instance.getBroker());
            this.withDelivery(instance.getDelivery());
            this.withFilter(instance.getFilter());
            this.withFilters(instance.getFilters());
            this.withSubscriber(instance.getSubscriber());
        }
    }

    public String getBroker() {
        return this.broker;
    }

    public A withBroker(String broker) {
        this.broker = broker;
        return (A)((Object)this);
    }

    public boolean hasBroker() {
        return this.broker != null;
    }

    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    public A withDelivery(DeliverySpec delivery) {
        this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove((Object)this.delivery);
        }
        return (A)((Object)this);
    }

    public boolean hasDelivery() {
        return this.delivery != null;
    }

    public DeliveryNested<A> withNewDelivery() {
        return new DeliveryNested(null);
    }

    public DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNested(item);
    }

    public DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(null));
    }

    public DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(new DeliverySpecBuilder().build()));
    }

    public DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(Optional.ofNullable(this.buildDelivery()).orElse(item));
    }

    public TriggerFilter buildFilter() {
        return this.filter != null ? this.filter.build() : null;
    }

    public A withFilter(TriggerFilter filter) {
        this._visitables.get((Object)"filter").remove((Object)this.filter);
        if (filter != null) {
            this.filter = new TriggerFilterBuilder(filter);
            this._visitables.get((Object)"filter").add(this.filter);
        } else {
            this.filter = null;
            this._visitables.get((Object)"filter").remove((Object)this.filter);
        }
        return (A)((Object)this);
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public FilterNested<A> withNewFilter() {
        return new FilterNested(null);
    }

    public FilterNested<A> withNewFilterLike(TriggerFilter item) {
        return new FilterNested(item);
    }

    public FilterNested<A> editFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(null));
    }

    public FilterNested<A> editOrNewFilter() {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(new TriggerFilterBuilder().build()));
    }

    public FilterNested<A> editOrNewFilterLike(TriggerFilter item) {
        return this.withNewFilterLike(Optional.ofNullable(this.buildFilter()).orElse(item));
    }

    public A addToFilters(int index, SubscriptionsAPIFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToFilters(int index, SubscriptionsAPIFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToFilters(SubscriptionsAPIFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToFilters(Collection<SubscriptionsAPIFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromFilters(SubscriptionsAPIFilter ... items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromFilters(Collection<SubscriptionsAPIFilter> items) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").remove((Object)builder);
            this.filters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromFilters(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)((Object)this);
        }
        Iterator<SubscriptionsAPIFilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            SubscriptionsAPIFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SubscriptionsAPIFilter> buildFilters() {
        return this.filters != null ? TriggerSpecFluent.build(this.filters) : null;
    }

    public SubscriptionsAPIFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    public SubscriptionsAPIFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    public SubscriptionsAPIFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    public SubscriptionsAPIFilter buildMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        for (SubscriptionsAPIFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        for (SubscriptionsAPIFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withFilters(List<SubscriptionsAPIFilter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (SubscriptionsAPIFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)((Object)this);
    }

    public A withFilters(SubscriptionsAPIFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (SubscriptionsAPIFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public FiltersNested<A> addNewFilter() {
        return new FiltersNested(-1, null);
    }

    public FiltersNested<A> addNewFilterLike(SubscriptionsAPIFilter item) {
        return new FiltersNested(-1, item);
    }

    public FiltersNested<A> setNewFilterLike(int index, SubscriptionsAPIFilter item) {
        return new FiltersNested(index, item);
    }

    public FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    public FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public FiltersNested<A> editMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    public Destination buildSubscriber() {
        return this.subscriber != null ? this.subscriber.build() : null;
    }

    public A withSubscriber(Destination subscriber) {
        this._visitables.get((Object)"subscriber").remove((Object)this.subscriber);
        if (subscriber != null) {
            this.subscriber = new DestinationBuilder(subscriber);
            this._visitables.get((Object)"subscriber").add(this.subscriber);
        } else {
            this.subscriber = null;
            this._visitables.get((Object)"subscriber").remove((Object)this.subscriber);
        }
        return (A)((Object)this);
    }

    public boolean hasSubscriber() {
        return this.subscriber != null;
    }

    public SubscriberNested<A> withNewSubscriber() {
        return new SubscriberNested(null);
    }

    public SubscriberNested<A> withNewSubscriberLike(Destination item) {
        return new SubscriberNested(item);
    }

    public SubscriberNested<A> editSubscriber() {
        return this.withNewSubscriberLike(Optional.ofNullable(this.buildSubscriber()).orElse(null));
    }

    public SubscriberNested<A> editOrNewSubscriber() {
        return this.withNewSubscriberLike(Optional.ofNullable(this.buildSubscriber()).orElse(new DestinationBuilder().build()));
    }

    public SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
        return this.withNewSubscriberLike(Optional.ofNullable(this.buildSubscriber()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TriggerSpecFluent that = (TriggerSpecFluent)((Object)o);
        if (!Objects.equals(this.broker, that.broker)) {
            return false;
        }
        if (!Objects.equals((Object)this.delivery, (Object)that.delivery)) {
            return false;
        }
        if (!Objects.equals((Object)this.filter, (Object)that.filter)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        return Objects.equals((Object)this.subscriber, (Object)that.subscriber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.broker, this.delivery, this.filter, this.filters, this.subscriber, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.broker != null) {
            sb.append("broker:");
            sb.append(this.broker + ",");
        }
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append((Object)((Object)this.delivery) + ",");
        }
        if (this.filter != null) {
            sb.append("filter:");
            sb.append((Object)((Object)this.filter) + ",");
        }
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.subscriber != null) {
            sb.append("subscriber:");
            sb.append((Object)this.subscriber);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubscriberNested<N>
    extends DestinationFluent<SubscriberNested<N>>
    implements Nested<N> {
        DestinationBuilder builder;

        SubscriberNested(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        public N and() {
            return (N)TriggerSpecFluent.this.withSubscriber(this.builder.build());
        }

        public N endSubscriber() {
            return this.and();
        }
    }

    public class FiltersNested<N>
    extends SubscriptionsAPIFilterFluent<FiltersNested<N>>
    implements Nested<N> {
        SubscriptionsAPIFilterBuilder builder;
        int index;

        FiltersNested(int index, SubscriptionsAPIFilter item) {
            this.index = index;
            this.builder = new SubscriptionsAPIFilterBuilder(this, item);
        }

        public N and() {
            return (N)TriggerSpecFluent.this.setToFilters(this.index, this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }

    public class FilterNested<N>
    extends TriggerFilterFluent<FilterNested<N>>
    implements Nested<N> {
        TriggerFilterBuilder builder;

        FilterNested(TriggerFilter item) {
            this.builder = new TriggerFilterBuilder(this, item);
        }

        public N and() {
            return (N)TriggerSpecFluent.this.withFilter(this.builder.build());
        }

        public N endFilter() {
            return this.and();
        }
    }

    public class DeliveryNested<N>
    extends DeliverySpecFluent<DeliveryNested<N>>
    implements Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNested(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        public N and() {
            return (N)TriggerSpecFluent.this.withDelivery(this.builder.build());
        }

        public N endDelivery() {
            return this.and();
        }
    }
}

