/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ChannelTemplateSpecFluentImpl<A extends ChannelTemplateSpecFluent<A>>
extends BaseFluent<A>
implements ChannelTemplateSpecFluent<A> {
    private String apiVersion;
    private String kind;
    private Map<String, Object> spec;

    public ChannelTemplateSpecFluentImpl() {
    }

    public ChannelTemplateSpecFluentImpl(ChannelTemplateSpec instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withSpec(instance.getSpec());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A addToSpec(String key, Object value) {
        if (this.spec == null && key != null && value != null) {
            this.spec = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.spec.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSpec(Map<String, Object> map) {
        if (this.spec == null && map != null) {
            this.spec = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.spec.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSpec(String key) {
        if (this.spec == null) {
            return (A)this;
        }
        if (key != null && this.spec != null) {
            this.spec.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSpec(Map<String, Object> map) {
        if (this.spec == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.spec == null) continue;
                this.spec.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getSpec() {
        return this.spec;
    }

    @Override
    public <K, V> A withSpec(Map<String, Object> spec) {
        this.spec = spec == null ? null : new LinkedHashMap<String, Object>(spec);
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChannelTemplateSpecFluentImpl that = (ChannelTemplateSpecFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.spec, that.spec);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.spec, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.spec != null && !this.spec.isEmpty()) {
            sb.append("spec:");
            sb.append(this.spec);
        }
        sb.append("}");
        return sb.toString();
    }
}

