/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.contrib.kafka.v1beta1;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelStatus;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelStatusFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatus;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberStatusFluentImpl;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReference;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.KReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaChannelStatusFluentImpl<A extends KafkaChannelStatusFluent<A>>
extends BaseFluent<A>
implements KafkaChannelStatusFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private KReferenceBuilder deadLetterChannel;
    private String deadLetterSinkUri;
    private Long observedGeneration;
    private ArrayList<SubscriberStatusBuilder> subscribers = new ArrayList();

    public KafkaChannelStatusFluentImpl() {
    }

    public KafkaChannelStatusFluentImpl(KafkaChannelStatus instance) {
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withDeadLetterChannel(instance.getDeadLetterChannel());
            this.withDeadLetterSinkUri(instance.getDeadLetterSinkUri());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withSubscribers(instance.getSubscribers());
        }
    }

    @Override
    @Deprecated
    public Addressable getAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove(this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        } else {
            this.address = null;
            this._visitables.get((Object)"address").remove(this.address);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String url) {
        return this.withAddress(new Addressable(url));
    }

    @Override
    public KafkaChannelStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    @Override
    public KafkaChannelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    @Override
    public KafkaChannelStatusFluent.AddressNested<A> editAddress() {
        return this.withNewAddressLike(this.getAddress());
    }

    @Override
    public KafkaChannelStatusFluent.AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : new AddressableBuilder().build());
    }

    @Override
    public KafkaChannelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : item);
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return this.conditions != null ? KafkaChannelStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<Condition> buildConditions() {
        return this.conditions != null ? KafkaChannelStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public KafkaChannelStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public KReference getDeadLetterChannel() {
        return this.deadLetterChannel != null ? this.deadLetterChannel.build() : null;
    }

    @Override
    public KReference buildDeadLetterChannel() {
        return this.deadLetterChannel != null ? this.deadLetterChannel.build() : null;
    }

    @Override
    public A withDeadLetterChannel(KReference deadLetterChannel) {
        this._visitables.get((Object)"deadLetterChannel").remove(this.deadLetterChannel);
        if (deadLetterChannel != null) {
            this.deadLetterChannel = new KReferenceBuilder(deadLetterChannel);
            this._visitables.get((Object)"deadLetterChannel").add(this.deadLetterChannel);
        } else {
            this.deadLetterChannel = null;
            this._visitables.get((Object)"deadLetterChannel").remove(this.deadLetterChannel);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDeadLetterChannel() {
        return this.deadLetterChannel != null;
    }

    @Override
    public A withNewDeadLetterChannel(String apiVersion, String group, String kind, String name, String namespace) {
        return this.withDeadLetterChannel(new KReference(apiVersion, group, kind, name, namespace));
    }

    @Override
    public KafkaChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannel() {
        return new DeadLetterChannelNestedImpl();
    }

    @Override
    public KafkaChannelStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannelLike(KReference item) {
        return new DeadLetterChannelNestedImpl(item);
    }

    @Override
    public KafkaChannelStatusFluent.DeadLetterChannelNested<A> editDeadLetterChannel() {
        return this.withNewDeadLetterChannelLike(this.getDeadLetterChannel());
    }

    @Override
    public KafkaChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannel() {
        return this.withNewDeadLetterChannelLike(this.getDeadLetterChannel() != null ? this.getDeadLetterChannel() : new KReferenceBuilder().build());
    }

    @Override
    public KafkaChannelStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannelLike(KReference item) {
        return this.withNewDeadLetterChannelLike(this.getDeadLetterChannel() != null ? this.getDeadLetterChannel() : item);
    }

    @Override
    public String getDeadLetterSinkUri() {
        return this.deadLetterSinkUri;
    }

    @Override
    public A withDeadLetterSinkUri(String deadLetterSinkUri) {
        this.deadLetterSinkUri = deadLetterSinkUri;
        return (A)this;
    }

    @Override
    public Boolean hasDeadLetterSinkUri() {
        return this.deadLetterSinkUri != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToSubscribers(int index, SubscriberStatus item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
        if (index < 0 || index >= this.subscribers.size()) {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        } else {
            this._visitables.get((Object)"subscribers").add(index, builder);
            this.subscribers.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToSubscribers(int index, SubscriberStatus item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
        if (index < 0 || index >= this.subscribers.size()) {
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        } else {
            this._visitables.get((Object)"subscribers").set(index, builder);
            this.subscribers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubscribers(SubscriberStatus ... items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        for (SubscriberStatus item : items) {
            SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubscribers(Collection<SubscriberStatus> items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList();
        }
        for (SubscriberStatus item : items) {
            SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubscribers(SubscriberStatus ... items) {
        for (SubscriberStatus item : items) {
            SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubscribers(Collection<SubscriberStatus> items) {
        for (SubscriberStatus item : items) {
            SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubscribers(Predicate<SubscriberStatusBuilder> predicate) {
        if (this.subscribers == null) {
            return (A)this;
        }
        Iterator<SubscriberStatusBuilder> each = this.subscribers.iterator();
        List visitables = this._visitables.get((Object)"subscribers");
        while (each.hasNext()) {
            SubscriberStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SubscriberStatus> getSubscribers() {
        return this.subscribers != null ? KafkaChannelStatusFluentImpl.build(this.subscribers) : null;
    }

    @Override
    public List<SubscriberStatus> buildSubscribers() {
        return this.subscribers != null ? KafkaChannelStatusFluentImpl.build(this.subscribers) : null;
    }

    @Override
    public SubscriberStatus buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    @Override
    public SubscriberStatus buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    @Override
    public SubscriberStatus buildLastSubscriber() {
        return this.subscribers.get(this.subscribers.size() - 1).build();
    }

    @Override
    public SubscriberStatus buildMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
        for (SubscriberStatusBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
        for (SubscriberStatusBuilder item : this.subscribers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubscribers(List<SubscriberStatus> subscribers) {
        if (this.subscribers != null) {
            this._visitables.get((Object)"subscribers").clear();
        }
        if (subscribers != null) {
            this.subscribers = new ArrayList();
            for (SubscriberStatus item : subscribers) {
                this.addToSubscribers(item);
            }
        } else {
            this.subscribers = null;
        }
        return (A)this;
    }

    @Override
    public A withSubscribers(SubscriberStatus ... subscribers) {
        if (this.subscribers != null) {
            this.subscribers.clear();
            this._visitables.remove((Object)"subscribers");
        }
        if (subscribers != null) {
            for (SubscriberStatus item : subscribers) {
                this.addToSubscribers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubscribers() {
        return this.subscribers != null && !this.subscribers.isEmpty();
    }

    @Override
    public A addNewSubscriber(String message, Long observedGeneration, String ready, String uid) {
        return this.addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNestedImpl();
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberStatus item) {
        return new SubscribersNestedImpl(-1, item);
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index, SubscriberStatus item) {
        return new SubscribersNestedImpl(index, item);
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> editSubscriber(int index) {
        if (this.subscribers.size() <= index) {
            throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> editFirstSubscriber() {
        if (this.subscribers.size() == 0) {
            throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(0, this.buildSubscriber(0));
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> editLastSubscriber() {
        int index = this.subscribers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public KafkaChannelStatusFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!predicate.test(this.subscribers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subscribers. No match found.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaChannelStatusFluentImpl that = (KafkaChannelStatusFluentImpl)o;
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterChannel, that.deadLetterChannel)) {
            return false;
        }
        if (!Objects.equals(this.deadLetterSinkUri, that.deadLetterSinkUri)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.subscribers, that.subscribers);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.annotations, this.conditions, this.deadLetterChannel, this.deadLetterSinkUri, this.observedGeneration, this.subscribers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.deadLetterChannel != null) {
            sb.append("deadLetterChannel:");
            sb.append(this.deadLetterChannel + ",");
        }
        if (this.deadLetterSinkUri != null) {
            sb.append("deadLetterSinkUri:");
            sb.append(this.deadLetterSinkUri + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.subscribers != null) {
            sb.append("subscribers:");
            sb.append(this.subscribers);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubscribersNestedImpl<N>
    extends SubscriberStatusFluentImpl<KafkaChannelStatusFluent.SubscribersNested<N>>
    implements KafkaChannelStatusFluent.SubscribersNested<N>,
    Nested<N> {
        SubscriberStatusBuilder builder;
        int index;

        SubscribersNestedImpl(int index, SubscriberStatus item) {
            this.index = index;
            this.builder = new SubscriberStatusBuilder(this, item);
        }

        SubscribersNestedImpl() {
            this.index = -1;
            this.builder = new SubscriberStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaChannelStatusFluentImpl.this.setToSubscribers(this.index, this.builder.build());
        }

        @Override
        public N endSubscriber() {
            return this.and();
        }
    }

    class DeadLetterChannelNestedImpl<N>
    extends KReferenceFluentImpl<KafkaChannelStatusFluent.DeadLetterChannelNested<N>>
    implements KafkaChannelStatusFluent.DeadLetterChannelNested<N>,
    Nested<N> {
        KReferenceBuilder builder;

        DeadLetterChannelNestedImpl(KReference item) {
            this.builder = new KReferenceBuilder(this, item);
        }

        DeadLetterChannelNestedImpl() {
            this.builder = new KReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaChannelStatusFluentImpl.this.withDeadLetterChannel(this.builder.build());
        }

        @Override
        public N endDeadLetterChannel() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<KafkaChannelStatusFluent.ConditionsNested<N>>
    implements KafkaChannelStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaChannelStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class AddressNestedImpl<N>
    extends AddressableFluentImpl<KafkaChannelStatusFluent.AddressNested<N>>
    implements KafkaChannelStatusFluent.AddressNested<N>,
    Nested<N> {
        AddressableBuilder builder;

        AddressNestedImpl(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        AddressNestedImpl() {
            this.builder = new AddressableBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaChannelStatusFluentImpl.this.withAddress(this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

