/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.serving.v1.ContainerStatus;
import io.fabric8.knative.serving.v1.ContainerStatusBuilder;
import io.fabric8.knative.serving.v1.ContainerStatusFluentImpl;
import io.fabric8.knative.serving.v1.RevisionStatus;
import io.fabric8.knative.serving.v1.RevisionStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RevisionStatusFluentImpl<A extends RevisionStatusFluent<A>>
extends BaseFluent<A>
implements RevisionStatusFluent<A> {
    private Integer actualReplicas;
    private Map<String, String> annotations;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private ArrayList<ContainerStatusBuilder> containerStatuses = new ArrayList();
    private Integer desiredReplicas;
    private ArrayList<ContainerStatusBuilder> initContainerStatuses = new ArrayList();
    private String logUrl;
    private Long observedGeneration;

    public RevisionStatusFluentImpl() {
    }

    public RevisionStatusFluentImpl(RevisionStatus instance) {
        if (instance != null) {
            this.withActualReplicas(instance.getActualReplicas());
            this.withAnnotations(instance.getAnnotations());
            this.withConditions(instance.getConditions());
            this.withContainerStatuses(instance.getContainerStatuses());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withInitContainerStatuses(instance.getInitContainerStatuses());
            this.withLogUrl(instance.getLogUrl());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    @Override
    public Integer getActualReplicas() {
        return this.actualReplicas;
    }

    @Override
    public A withActualReplicas(Integer actualReplicas) {
        this.actualReplicas = actualReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasActualReplicas() {
        return this.actualReplicas != null;
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return this.conditions != null ? RevisionStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<Condition> buildConditions() {
        return this.conditions != null ? RevisionStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"containerStatuses").add(index, builder);
            this.containerStatuses.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToContainerStatuses(int index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"containerStatuses").set(index, builder);
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.containerStatuses.iterator();
        List visitables = this._visitables.get((Object)"containerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getContainerStatuses() {
        return this.containerStatuses != null ? RevisionStatusFluentImpl.build(this.containerStatuses) : null;
    }

    @Override
    public List<ContainerStatus> buildContainerStatuses() {
        return this.containerStatuses != null ? RevisionStatusFluentImpl.build(this.containerStatuses) : null;
    }

    @Override
    public ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get((Object)"containerStatuses").clear();
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList();
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
            this._visitables.remove((Object)"containerStatuses");
        }
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    @Override
    public A addNewContainerStatus(String imageDigest, String name) {
        return this.addToContainerStatuses(new ContainerStatus(imageDigest, name));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index, ContainerStatus item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    public A addToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"initContainerStatuses").add(index, builder);
            this.initContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToInitContainerStatuses(int index, ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get((Object)"initContainerStatuses").set(index, builder);
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainerStatuses(ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        List visitables = this._visitables.get((Object)"initContainerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getInitContainerStatuses() {
        return this.initContainerStatuses != null ? RevisionStatusFluentImpl.build(this.initContainerStatuses) : null;
    }

    @Override
    public List<ContainerStatus> buildInitContainerStatuses() {
        return this.initContainerStatuses != null ? RevisionStatusFluentImpl.build(this.initContainerStatuses) : null;
    }

    @Override
    public ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get((Object)"initContainerStatuses").clear();
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList();
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
            this._visitables.remove((Object)"initContainerStatuses");
        }
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    @Override
    public A addNewInitContainerStatus(String imageDigest, String name) {
        return this.addToInitContainerStatuses(new ContainerStatus(imageDigest, name));
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNestedImpl();
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(index, item);
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public RevisionStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.test(this.initContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public String getLogUrl() {
        return this.logUrl;
    }

    @Override
    public A withLogUrl(String logUrl) {
        this.logUrl = logUrl;
        return (A)this;
    }

    @Override
    public Boolean hasLogUrl() {
        return this.logUrl != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionStatusFluentImpl that = (RevisionStatusFluentImpl)o;
        if (!Objects.equals(this.actualReplicas, that.actualReplicas)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.containerStatuses, that.containerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.initContainerStatuses, that.initContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.logUrl, that.logUrl)) {
            return false;
        }
        return Objects.equals(this.observedGeneration, that.observedGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.actualReplicas, this.annotations, this.conditions, this.containerStatuses, this.desiredReplicas, this.initContainerStatuses, this.logUrl, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actualReplicas != null) {
            sb.append("actualReplicas:");
            sb.append(this.actualReplicas + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.containerStatuses != null) {
            sb.append("containerStatuses:");
            sb.append(this.containerStatuses + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.initContainerStatuses != null) {
            sb.append("initContainerStatuses:");
            sb.append(this.initContainerStatuses + ",");
        }
        if (this.logUrl != null) {
            sb.append("logUrl:");
            sb.append(this.logUrl + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    class InitContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<RevisionStatusFluent.InitContainerStatusesNested<N>>
    implements RevisionStatusFluent.InitContainerStatusesNested<N>,
    Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        InitContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        InitContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)RevisionStatusFluentImpl.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endInitContainerStatus() {
            return this.and();
        }
    }

    class ContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<RevisionStatusFluent.ContainerStatusesNested<N>>
    implements RevisionStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        ContainerStatusBuilder builder;
        int index;

        ContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)RevisionStatusFluentImpl.this.setToContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<RevisionStatusFluent.ConditionsNested<N>>
    implements RevisionStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)RevisionStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

