/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.eventing.v1.SubscriptionsAPIFilter;
import io.fabric8.knative.eventing.v1.SubscriptionsAPIFilterBuilder;
import io.fabric8.knative.eventing.v1.SubscriptionsAPIFilterFluentImpl;
import io.fabric8.knative.eventing.v1.TriggerFilter;
import io.fabric8.knative.eventing.v1.TriggerFilterBuilder;
import io.fabric8.knative.eventing.v1.TriggerFilterFluentImpl;
import io.fabric8.knative.eventing.v1.TriggerSpec;
import io.fabric8.knative.eventing.v1.TriggerSpecFluent;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TriggerSpecFluentImpl<A extends TriggerSpecFluent<A>>
extends BaseFluent<A>
implements TriggerSpecFluent<A> {
    private String broker;
    private DeliverySpecBuilder delivery;
    private TriggerFilterBuilder filter;
    private ArrayList<SubscriptionsAPIFilterBuilder> filters = new ArrayList();
    private DestinationBuilder subscriber;

    public TriggerSpecFluentImpl() {
    }

    public TriggerSpecFluentImpl(TriggerSpec instance) {
        if (instance != null) {
            this.withBroker(instance.getBroker());
            this.withDelivery(instance.getDelivery());
            this.withFilter(instance.getFilter());
            this.withFilters(instance.getFilters());
            this.withSubscriber(instance.getSubscriber());
        }
    }

    @Override
    public String getBroker() {
        return this.broker;
    }

    @Override
    public A withBroker(String broker) {
        this.broker = broker;
        return (A)this;
    }

    @Override
    public Boolean hasBroker() {
        return this.broker != null;
    }

    @Override
    @Deprecated
    public DeliverySpec getDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public A withDelivery(DeliverySpec delivery) {
        this._visitables.get((Object)"delivery").remove(this.delivery);
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        } else {
            this.delivery = null;
            this._visitables.get((Object)"delivery").remove(this.delivery);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    @Override
    public TriggerSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    @Override
    public TriggerSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    @Override
    public TriggerSpecFluent.DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(this.getDelivery());
    }

    @Override
    public TriggerSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : new DeliverySpecBuilder().build());
    }

    @Override
    public TriggerSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : item);
    }

    @Override
    @Deprecated
    public TriggerFilter getFilter() {
        return this.filter != null ? this.filter.build() : null;
    }

    @Override
    public TriggerFilter buildFilter() {
        return this.filter != null ? this.filter.build() : null;
    }

    @Override
    public A withFilter(TriggerFilter filter) {
        this._visitables.get((Object)"filter").remove(this.filter);
        if (filter != null) {
            this.filter = new TriggerFilterBuilder(filter);
            this._visitables.get((Object)"filter").add(this.filter);
        } else {
            this.filter = null;
            this._visitables.get((Object)"filter").remove(this.filter);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFilter() {
        return this.filter != null;
    }

    @Override
    public TriggerSpecFluent.FilterNested<A> withNewFilter() {
        return new FilterNestedImpl();
    }

    @Override
    public TriggerSpecFluent.FilterNested<A> withNewFilterLike(TriggerFilter item) {
        return new FilterNestedImpl(item);
    }

    @Override
    public TriggerSpecFluent.FilterNested<A> editFilter() {
        return this.withNewFilterLike(this.getFilter());
    }

    @Override
    public TriggerSpecFluent.FilterNested<A> editOrNewFilter() {
        return this.withNewFilterLike(this.getFilter() != null ? this.getFilter() : new TriggerFilterBuilder().build());
    }

    @Override
    public TriggerSpecFluent.FilterNested<A> editOrNewFilterLike(TriggerFilter item) {
        return this.withNewFilterLike(this.getFilter() != null ? this.getFilter() : item);
    }

    @Override
    public A addToFilters(int index, SubscriptionsAPIFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").add(index, builder);
            this.filters.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToFilters(int index, SubscriptionsAPIFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
        if (index < 0 || index >= this.filters.size()) {
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFilters(SubscriptionsAPIFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFilters(Collection<SubscriptionsAPIFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFilters(SubscriptionsAPIFilter ... items) {
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFilters(Collection<SubscriptionsAPIFilter> items) {
        for (SubscriptionsAPIFilter item : items) {
            SubscriptionsAPIFilterBuilder builder = new SubscriptionsAPIFilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFilters(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<SubscriptionsAPIFilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            SubscriptionsAPIFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SubscriptionsAPIFilter> getFilters() {
        return this.filters != null ? TriggerSpecFluentImpl.build(this.filters) : null;
    }

    @Override
    public List<SubscriptionsAPIFilter> buildFilters() {
        return this.filters != null ? TriggerSpecFluentImpl.build(this.filters) : null;
    }

    @Override
    public SubscriptionsAPIFilter buildFilter(int index) {
        return this.filters.get(index).build();
    }

    @Override
    public SubscriptionsAPIFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    @Override
    public SubscriptionsAPIFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    @Override
    public SubscriptionsAPIFilter buildMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        for (SubscriptionsAPIFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        for (SubscriptionsAPIFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFilters(List<SubscriptionsAPIFilter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").clear();
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (SubscriptionsAPIFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    @Override
    public A withFilters(SubscriptionsAPIFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
            this._visitables.remove((Object)"filters");
        }
        if (filters != null) {
            for (SubscriptionsAPIFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> addNewFilter() {
        return new FiltersNestedImpl();
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> addNewFilterLike(SubscriptionsAPIFilter item) {
        return new FiltersNestedImpl(-1, item);
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> setNewFilterLike(int index, SubscriptionsAPIFilter item) {
        return new FiltersNestedImpl(index, item);
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> editFilter(int index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public TriggerSpecFluent.FiltersNested<A> editMatchingFilter(Predicate<SubscriptionsAPIFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    @Deprecated
    public Destination getSubscriber() {
        return this.subscriber != null ? this.subscriber.build() : null;
    }

    @Override
    public Destination buildSubscriber() {
        return this.subscriber != null ? this.subscriber.build() : null;
    }

    @Override
    public A withSubscriber(Destination subscriber) {
        this._visitables.get((Object)"subscriber").remove(this.subscriber);
        if (subscriber != null) {
            this.subscriber = new DestinationBuilder(subscriber);
            this._visitables.get((Object)"subscriber").add(this.subscriber);
        } else {
            this.subscriber = null;
            this._visitables.get((Object)"subscriber").remove(this.subscriber);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubscriber() {
        return this.subscriber != null;
    }

    @Override
    public TriggerSpecFluent.SubscriberNested<A> withNewSubscriber() {
        return new SubscriberNestedImpl();
    }

    @Override
    public TriggerSpecFluent.SubscriberNested<A> withNewSubscriberLike(Destination item) {
        return new SubscriberNestedImpl(item);
    }

    @Override
    public TriggerSpecFluent.SubscriberNested<A> editSubscriber() {
        return this.withNewSubscriberLike(this.getSubscriber());
    }

    @Override
    public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriber() {
        return this.withNewSubscriberLike(this.getSubscriber() != null ? this.getSubscriber() : new DestinationBuilder().build());
    }

    @Override
    public TriggerSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(Destination item) {
        return this.withNewSubscriberLike(this.getSubscriber() != null ? this.getSubscriber() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TriggerSpecFluentImpl that = (TriggerSpecFluentImpl)o;
        if (!Objects.equals(this.broker, that.broker)) {
            return false;
        }
        if (!Objects.equals(this.delivery, that.delivery)) {
            return false;
        }
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        if (!Objects.equals(this.filters, that.filters)) {
            return false;
        }
        return Objects.equals(this.subscriber, that.subscriber);
    }

    public int hashCode() {
        return Objects.hash(this.broker, this.delivery, this.filter, this.filters, this.subscriber, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.broker != null) {
            sb.append("broker:");
            sb.append(this.broker + ",");
        }
        if (this.delivery != null) {
            sb.append("delivery:");
            sb.append(this.delivery + ",");
        }
        if (this.filter != null) {
            sb.append("filter:");
            sb.append(this.filter + ",");
        }
        if (this.filters != null) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.subscriber != null) {
            sb.append("subscriber:");
            sb.append(this.subscriber);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubscriberNestedImpl<N>
    extends DestinationFluentImpl<TriggerSpecFluent.SubscriberNested<N>>
    implements TriggerSpecFluent.SubscriberNested<N>,
    Nested<N> {
        DestinationBuilder builder;

        SubscriberNestedImpl(Destination item) {
            this.builder = new DestinationBuilder(this, item);
        }

        SubscriberNestedImpl() {
            this.builder = new DestinationBuilder(this);
        }

        @Override
        public N and() {
            return (N)TriggerSpecFluentImpl.this.withSubscriber(this.builder.build());
        }

        @Override
        public N endSubscriber() {
            return this.and();
        }
    }

    class FiltersNestedImpl<N>
    extends SubscriptionsAPIFilterFluentImpl<TriggerSpecFluent.FiltersNested<N>>
    implements TriggerSpecFluent.FiltersNested<N>,
    Nested<N> {
        SubscriptionsAPIFilterBuilder builder;
        int index;

        FiltersNestedImpl(int index, SubscriptionsAPIFilter item) {
            this.index = index;
            this.builder = new SubscriptionsAPIFilterBuilder(this, item);
        }

        FiltersNestedImpl() {
            this.index = -1;
            this.builder = new SubscriptionsAPIFilterBuilder(this);
        }

        @Override
        public N and() {
            return (N)TriggerSpecFluentImpl.this.setToFilters(this.index, this.builder.build());
        }

        @Override
        public N endFilter() {
            return this.and();
        }
    }

    class FilterNestedImpl<N>
    extends TriggerFilterFluentImpl<TriggerSpecFluent.FilterNested<N>>
    implements TriggerSpecFluent.FilterNested<N>,
    Nested<N> {
        TriggerFilterBuilder builder;

        FilterNestedImpl(TriggerFilter item) {
            this.builder = new TriggerFilterBuilder(this, item);
        }

        FilterNestedImpl() {
            this.builder = new TriggerFilterBuilder(this);
        }

        @Override
        public N and() {
            return (N)TriggerSpecFluentImpl.this.withFilter(this.builder.build());
        }

        @Override
        public N endFilter() {
            return this.and();
        }
    }

    class DeliveryNestedImpl<N>
    extends DeliverySpecFluentImpl<TriggerSpecFluent.DeliveryNested<N>>
    implements TriggerSpecFluent.DeliveryNested<N>,
    Nested<N> {
        DeliverySpecBuilder builder;

        DeliveryNestedImpl(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        DeliveryNestedImpl() {
            this.builder = new DeliverySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)TriggerSpecFluentImpl.this.withDelivery(this.builder.build());
        }

        @Override
        public N endDelivery() {
            return this.and();
        }
    }
}

