/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.sources.v1;

import io.fabric8.knative.sources.v1.ApiServerSource;
import io.fabric8.knative.sources.v1.ApiServerSourceFluent;
import io.fabric8.knative.sources.v1.ApiServerSourceSpec;
import io.fabric8.knative.sources.v1.ApiServerSourceSpecBuilder;
import io.fabric8.knative.sources.v1.ApiServerSourceSpecFluentImpl;
import io.fabric8.knative.sources.v1.ApiServerSourceStatus;
import io.fabric8.knative.sources.v1.ApiServerSourceStatusBuilder;
import io.fabric8.knative.sources.v1.ApiServerSourceStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.Objects;

public class ApiServerSourceFluentImpl<A extends ApiServerSourceFluent<A>>
extends BaseFluent<A>
implements ApiServerSourceFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ApiServerSourceSpecBuilder spec;
    private ApiServerSourceStatusBuilder status;

    public ApiServerSourceFluentImpl() {
    }

    public ApiServerSourceFluentImpl(ApiServerSource instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ApiServerSourceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ApiServerSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ApiServerSourceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ApiServerSourceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ApiServerSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ApiServerSourceSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ApiServerSourceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ApiServerSourceSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ApiServerSourceSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ApiServerSourceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ApiServerSourceFluent.SpecNested<A> withNewSpecLike(ApiServerSourceSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ApiServerSourceFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ApiServerSourceFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ApiServerSourceSpecBuilder().build());
    }

    @Override
    public ApiServerSourceFluent.SpecNested<A> editOrNewSpecLike(ApiServerSourceSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ApiServerSourceStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ApiServerSourceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ApiServerSourceStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ApiServerSourceStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ApiServerSourceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ApiServerSourceFluent.StatusNested<A> withNewStatusLike(ApiServerSourceStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ApiServerSourceFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ApiServerSourceFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ApiServerSourceStatusBuilder().build());
    }

    @Override
    public ApiServerSourceFluent.StatusNested<A> editOrNewStatusLike(ApiServerSourceStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiServerSourceFluentImpl that = (ApiServerSourceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends ApiServerSourceStatusFluentImpl<ApiServerSourceFluent.StatusNested<N>>
    implements ApiServerSourceFluent.StatusNested<N>,
    Nested<N> {
        ApiServerSourceStatusBuilder builder;

        StatusNestedImpl(ApiServerSourceStatus item) {
            this.builder = new ApiServerSourceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ApiServerSourceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApiServerSourceFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends ApiServerSourceSpecFluentImpl<ApiServerSourceFluent.SpecNested<N>>
    implements ApiServerSourceFluent.SpecNested<N>,
    Nested<N> {
        ApiServerSourceSpecBuilder builder;

        SpecNestedImpl(ApiServerSourceSpec item) {
            this.builder = new ApiServerSourceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ApiServerSourceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApiServerSourceFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ApiServerSourceFluent.MetadataNested<N>>
    implements ApiServerSourceFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ApiServerSourceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

