/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.eventing.v1;

import io.fabric8.knative.eventing.v1.BrokerStatus;
import io.fabric8.knative.eventing.v1.BrokerStatusFluent;
import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.internal.pkg.apis.duck.v1.Addressable;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.AddressableFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BrokerStatusFluentImpl<A extends BrokerStatusFluent<A>>
extends BaseFluent<A>
implements BrokerStatusFluent<A> {
    private AddressableBuilder address;
    private Map<String, String> annotations;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;

    public BrokerStatusFluentImpl() {
    }

    public BrokerStatusFluentImpl(BrokerStatus instance) {
        this.withAddress(instance.getAddress());
        this.withAnnotations(instance.getAnnotations());
        this.withConditions(instance.getConditions());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    @Deprecated
    public Addressable getAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public Addressable buildAddress() {
        return this.address != null ? this.address.build() : null;
    }

    @Override
    public A withAddress(Addressable address) {
        this._visitables.get((Object)"address").remove(this.address);
        if (address != null) {
            this.address = new AddressableBuilder(address);
            this._visitables.get((Object)"address").add(this.address);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public A withNewAddress(String url) {
        return this.withAddress(new Addressable(url));
    }

    @Override
    public BrokerStatusFluent.AddressNested<A> withNewAddress() {
        return new AddressNestedImpl();
    }

    @Override
    public BrokerStatusFluent.AddressNested<A> withNewAddressLike(Addressable item) {
        return new AddressNestedImpl(item);
    }

    @Override
    public BrokerStatusFluent.AddressNested<A> editAddress() {
        return this.withNewAddressLike(this.getAddress());
    }

    @Override
    public BrokerStatusFluent.AddressNested<A> editOrNewAddress() {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : new AddressableBuilder().build());
    }

    @Override
    public BrokerStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item) {
        return this.withNewAddressLike(this.getAddress() != null ? this.getAddress() : item);
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return BrokerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<Condition> buildConditions() {
        return BrokerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ConditionBuilder>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public BrokerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A withNewObservedGeneration(String arg1) {
        return this.withObservedGeneration(new Long(arg1));
    }

    @Override
    public A withNewObservedGeneration(long arg1) {
        return this.withObservedGeneration(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerStatusFluentImpl that = (BrokerStatusFluentImpl)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.annotations, this.conditions, this.observedGeneration, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<BrokerStatusFluent.ConditionsNested<N>>
    implements BrokerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BrokerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class AddressNestedImpl<N>
    extends AddressableFluentImpl<BrokerStatusFluent.AddressNested<N>>
    implements BrokerStatusFluent.AddressNested<N>,
    Nested<N> {
        private final AddressableBuilder builder;

        AddressNestedImpl(Addressable item) {
            this.builder = new AddressableBuilder(this, item);
        }

        AddressNestedImpl() {
            this.builder = new AddressableBuilder(this);
        }

        @Override
        public N and() {
            return (N)BrokerStatusFluentImpl.this.withAddress(this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

