/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.knative.internal.pkg.apis.ConditionBuilder;
import io.fabric8.knative.internal.pkg.apis.ConditionFluentImpl;
import io.fabric8.knative.serving.v1.ContainerStatus;
import io.fabric8.knative.serving.v1.ContainerStatusBuilder;
import io.fabric8.knative.serving.v1.ContainerStatusFluentImpl;
import io.fabric8.knative.serving.v1.RevisionStatus;
import io.fabric8.knative.serving.v1.RevisionStatusFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RevisionStatusFluentImpl<A extends RevisionStatusFluent<A>>
extends BaseFluent<A>
implements RevisionStatusFluent<A> {
    private Integer actualReplicas;
    private Map<String, String> annotations;
    private List<ConditionBuilder> conditions;
    private List<ContainerStatusBuilder> containerStatuses;
    private Integer desiredReplicas;
    private String imageDigest;
    private String logUrl;
    private Long observedGeneration;
    private String serviceName;

    public RevisionStatusFluentImpl() {
    }

    public RevisionStatusFluentImpl(RevisionStatus instance) {
        this.withActualReplicas(instance.getActualReplicas());
        this.withAnnotations(instance.getAnnotations());
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withImageDigest(instance.getImageDigest());
        this.withLogUrl(instance.getLogUrl());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withServiceName(instance.getServiceName());
    }

    @Override
    public Integer getActualReplicas() {
        return this.actualReplicas;
    }

    @Override
    public A withActualReplicas(Integer actualReplicas) {
        this.actualReplicas = actualReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasActualReplicas() {
        return this.actualReplicas != null;
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get((Object)"conditions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"conditions").size()) {
            this._visitables.get((Object)"conditions").add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return RevisionStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<Condition> buildConditions() {
        return RevisionStatusFluentImpl.build(this.conditions);
    }

    @Override
    public Condition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ConditionBuilder>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToContainerStatuses(Integer index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        this._visitables.get((Object)"containerStatuses").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"containerStatuses").size(), builder);
        this.containerStatuses.add(index >= 0 ? index.intValue() : this.containerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainerStatuses(Integer index, ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"containerStatuses").size()) {
            this._visitables.get((Object)"containerStatuses").add(builder);
        } else {
            this._visitables.get((Object)"containerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.containerStatuses.size()) {
            this.containerStatuses.add(builder);
        } else {
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerStatuses(ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
        }
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.get((Object)"containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainerStatuses(Predicate<ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<ContainerStatusBuilder> each = this.containerStatuses.iterator();
        List visitables = this._visitables.get((Object)"containerStatuses");
        while (each.hasNext()) {
            ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getContainerStatuses() {
        return RevisionStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public List<ContainerStatus> buildContainerStatuses() {
        return RevisionStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public ContainerStatus buildContainerStatus(Integer index) {
        return this.containerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get((Object)"containerStatuses").removeAll(this.containerStatuses);
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList<ContainerStatusBuilder>();
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
        }
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    @Override
    public A addNewContainerStatus(String imageDigest, String name) {
        return this.addToContainerStatuses(new ContainerStatus(imageDigest, name));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(Integer index, ContainerStatus item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editContainerStatus(Integer index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public RevisionStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    public String getImageDigest() {
        return this.imageDigest;
    }

    @Override
    public A withImageDigest(String imageDigest) {
        this.imageDigest = imageDigest;
        return (A)this;
    }

    @Override
    public Boolean hasImageDigest() {
        return this.imageDigest != null;
    }

    @Override
    @Deprecated
    public A withNewImageDigest(String arg0) {
        return this.withImageDigest(new String(arg0));
    }

    @Override
    public String getLogUrl() {
        return this.logUrl;
    }

    @Override
    public A withLogUrl(String logUrl) {
        this.logUrl = logUrl;
        return (A)this;
    }

    @Override
    public Boolean hasLogUrl() {
        return this.logUrl != null;
    }

    @Override
    @Deprecated
    public A withNewLogUrl(String arg0) {
        return this.withLogUrl(new String(arg0));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    @Deprecated
    public A withNewServiceName(String arg0) {
        return this.withServiceName(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevisionStatusFluentImpl that = (RevisionStatusFluentImpl)o;
        if (this.actualReplicas != null ? !this.actualReplicas.equals(that.actualReplicas) : that.actualReplicas != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.desiredReplicas != null ? !this.desiredReplicas.equals(that.desiredReplicas) : that.desiredReplicas != null) {
            return false;
        }
        if (this.imageDigest != null ? !this.imageDigest.equals(that.imageDigest) : that.imageDigest != null) {
            return false;
        }
        if (this.logUrl != null ? !this.logUrl.equals(that.logUrl) : that.logUrl != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        return !(this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null);
    }

    public int hashCode() {
        return Objects.hash(this.actualReplicas, this.annotations, this.conditions, this.containerStatuses, this.desiredReplicas, this.imageDigest, this.logUrl, this.observedGeneration, this.serviceName, super.hashCode());
    }

    public class ContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<RevisionStatusFluent.ContainerStatusesNested<N>>
    implements RevisionStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        ContainerStatusBuilder builder;
        Integer index;

        ContainerStatusesNestedImpl(Integer index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)RevisionStatusFluentImpl.this.setToContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<RevisionStatusFluent.ConditionsNested<N>>
    implements RevisionStatusFluent.ConditionsNested<N>,
    Nested<N> {
        ConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)RevisionStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

