/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1beta1;

import io.fabric8.knative.serving.v1beta1.RevisionSpec;
import io.fabric8.knative.serving.v1beta1.RevisionSpecFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>>
extends BaseFluent<A>
implements RevisionSpecFluent<A> {
    private Long containerConcurrency;
    private List<ContainerBuilder> containers;
    private String serviceAccountName;
    private Long timeoutSeconds;
    private List<VolumeBuilder> volumes;

    public RevisionSpecFluentImpl() {
    }

    public RevisionSpecFluentImpl(RevisionSpec instance) {
        this.withContainerConcurrency(instance.getContainerConcurrency());
        this.withContainers(instance.getContainers());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Long getContainerConcurrency() {
        return this.containerConcurrency;
    }

    @Override
    public A withContainerConcurrency(Long containerConcurrency) {
        this.containerConcurrency = containerConcurrency;
        return (A)this;
    }

    @Override
    public Boolean hasContainerConcurrency() {
        return this.containerConcurrency != null;
    }

    @Override
    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"containers").add(index >= 0 ? index : this._visitables.get((Object)"containers").size(), builder);
        this.containers.add(index >= 0 ? index : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"containers").size()) {
            this._visitables.get((Object)"containers").add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return RevisionSpecFluentImpl.build(this.containers);
    }

    @Override
    public List<Container> buildContainers() {
        return RevisionSpecFluentImpl.build(this.containers);
    }

    @Override
    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList<ContainerBuilder>();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = new ArrayList<ContainerBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public RevisionSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.apply((Object)this.containers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public A withNewServiceAccountName(String arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuilder arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public A withNewServiceAccountName(StringBuffer arg1) {
        return this.withServiceAccountName(new String(arg1));
    }

    @Override
    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return RevisionSpecFluentImpl.build(this.volumes);
    }

    @Override
    public List<Volume> buildVolumes() {
        return RevisionSpecFluentImpl.build(this.volumes);
    }

    @Override
    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<VolumeBuilder>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = new ArrayList<VolumeBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public RevisionSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.apply((Object)this.volumes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RevisionSpecFluentImpl that = (RevisionSpecFluentImpl)o;
        if (this.containerConcurrency != null ? !this.containerConcurrency.equals(that.containerConcurrency) : that.containerConcurrency != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.timeoutSeconds != null ? !this.timeoutSeconds.equals(that.timeoutSeconds) : that.timeoutSeconds != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class VolumesNestedImpl<N>
    extends VolumeFluentImpl<RevisionSpecFluent.VolumesNested<N>>
    implements RevisionSpecFluent.VolumesNested<N>,
    Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

        VolumesNestedImpl(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder((VolumeFluent)this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder((VolumeFluent)this);
        }

        @Override
        public N and() {
            return (N)RevisionSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    public class ContainersNestedImpl<N>
    extends ContainerFluentImpl<RevisionSpecFluent.ContainersNested<N>>
    implements RevisionSpecFluent.ContainersNested<N>,
    Nested<N> {
        private final ContainerBuilder builder;
        private final int index;

        ContainersNestedImpl(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder((ContainerFluent)this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder((ContainerFluent)this);
        }

        @Override
        public N and() {
            return (N)RevisionSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }
}

