/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.serving.v1;

import io.fabric8.knative.serving.v1.ServiceStatus;
import io.fabric8.knative.serving.v1.ServiceStatusFluent;
import io.fabric8.knative.serving.v1.ServiceStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ServiceStatusBuilder
extends ServiceStatusFluentImpl<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceStatusBuilder() {
        this(true);
    }

    public ServiceStatusBuilder(Boolean validationEnabled) {
        this(new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withConditions(instance.getConditions());
        fluent.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName());
        fluent.withLatestReadyRevisionName(instance.getLatestReadyRevisionName());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withTraffic(instance.getTraffic());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this(instance, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withAnnotations(instance.getAnnotations());
        this.withConditions(instance.getConditions());
        this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName());
        this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withTraffic(instance.getTraffic());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus(this.fluent.getAddress(), this.fluent.getAnnotations(), this.fluent.getConditions(), this.fluent.getLatestCreatedRevisionName(), this.fluent.getLatestReadyRevisionName(), this.fluent.getObservedGeneration(), this.fluent.getTraffic(), this.fluent.getUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceStatusBuilder that = (ServiceStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

