/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testing.jenkins;

import com.google.common.base.Optional;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildWithDetails;
import com.offbytwo.jenkins.model.FolderJob;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.QueueReference;
import io.fabric8.utils.Asserts;
import io.fabric8.utils.Block;
import io.fabric8.utils.Millis;
import io.fabric8.utils.Strings;
import io.fabric8.utils.XmlUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JenkinsAsserts {
    public static final String INDENT = "  ";
    private static final transient Logger LOG = LoggerFactory.getLogger(JenkinsAsserts.class);
    private static long defaultBuildWaitTime = Millis.minutes((int)2);

    public static JenkinsServer createJenkinsServer(String url) throws URISyntaxException {
        return new JenkinsServer(new URI(url));
    }

    public static JobWithDetails assertJobExists(JenkinsServer jenkins, String jobName) {
        JobWithDetails job = JenkinsAsserts.tryFindJob(jenkins, jobName);
        if (job != null) {
            return job;
        }
        Assertions.fail((String)("No job found called `" + jobName + "` for jenkins at " + jenkins));
        return job;
    }

    public static void assertJobLastBuildIsSuccessful(JenkinsServer jenkins, String jobName) throws Exception {
        JenkinsAsserts.assertJobLastBuildIsSuccessful(defaultBuildWaitTime, jenkins, jobName);
    }

    public static void assertJobLastBuildIsSuccessful(long timeMillis, final JenkinsServer jenkins, final String jobName) throws Exception {
        Asserts.assertWaitFor((long)timeMillis, (Block)new Block(){

            public void invoke() throws Exception {
                JobWithDetails job = JenkinsAsserts.assertJobExists(jenkins, jobName);
                Build lastBuild = job.getLastBuild();
                Assert.assertNotNull((String)("No lastBuild for job `" + jobName + "`"), (Object)lastBuild);
                System.out.println("Last build of `" + jobName + "` at " + lastBuild.getUrl());
                Build lastSuccessfulBuild = job.getLastSuccessfulBuild();
                Assert.assertNotNull((String)("No lastSuccessfulBuild for job `" + jobName + "` at: " + lastBuild.getUrl()), (Object)lastSuccessfulBuild);
                Assert.assertEquals((String)("Last successful build number was not the last build number: " + lastBuild.getUrl()), (long)lastBuild.getNumber(), (long)lastSuccessfulBuild.getNumber());
                System.out.println("Successful build of `" + jobName + "` at " + lastSuccessfulBuild.getUrl());
            }
        });
    }

    public static Build assertJobHasBuild(JenkinsServer jenkins, String jobName) {
        JobWithDetails job = JenkinsAsserts.assertJobExists(jenkins, jobName);
        Build lastBuild = job.getLastBuild();
        Assert.assertNotNull((String)("No lastBuild for job `" + jobName + "`"), (Object)lastBuild);
        return lastBuild;
    }

    public static void assertCreateJenkinsJob(JenkinsServer jenkinsServer, String xml, String jobName) {
        try {
            jenkinsServer.createJob(jobName, xml);
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed to create Jenkins job " + jobName + " for XML `" + xml + "`. " + e), (Throwable)e);
        }
    }

    public static String assertJobXml(JenkinsServer jenkinsServer, String jobName) {
        try {
            return jenkinsServer.getJobXml(jobName);
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed to find XML for Jenkins job " + jobName + ". " + e), (Throwable)e);
            return null;
        }
    }

    public static String createJenkinsPipelineJobXml(String jenkinsfile) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><org.jenkinsci.plugins.workflow.job.WorkflowJob plugin=\"workflow-job@1.15\">\n  <keepDependencies>false</keepDependencies>\n  <properties/>\n  <definition class=\"org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition\" plugin=\"workflow-cps@1.15\">\n    <script>" + jenkinsfile + "</script>\n    <sandbox>false</sandbox>\n  </definition>\n  <triggers/>\n</org.jenkinsci.plugins.workflow.job.WorkflowJob>";
    }

    protected static JobWithDetails tryFindJob(JenkinsServer jenkins, String jobName) {
        for (int i = 0; i < 15; ++i) {
            try {
                return jenkins.getJob(jobName);
            }
            catch (IOException e) {
                LOG.info("Caught: " + e, (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }

    public static void deleteAllCurrentJobs(JenkinsServer jenkins) throws IOException {
        int numberOfAttempts = 2;
        for (int i = 1; i < numberOfAttempts; ++i) {
            if (i > 1) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Map jobs = jenkins.getJobs();
            Set entries = jobs.entrySet();
            for (Map.Entry entry : entries) {
                String jobName = (String)entry.getKey();
                Job job = (Job)entry.getValue();
                LOG.info("Deleting job " + jobName);
                try {
                    jenkins.deleteJob(jobName, true);
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete job: " + jobName + ". " + e, (Throwable)e);
                }
            }
            if (JenkinsAsserts.numberOfJobs(jenkins) != 0) continue;
            return;
        }
    }

    public static int numberOfJobs(JenkinsServer jenkins) throws IOException {
        return jenkins.getJobs().size();
    }

    public static void displayJobs(JenkinsServer jenkins) throws IOException {
        JenkinsAsserts.displayJobs(jenkins, jenkins.getJobs(), INDENT);
    }

    public static void displayJobs(JenkinsServer jenkins, Map<String, Job> jobs, String indent) throws IOException {
        Set<Map.Entry<String, Job>> entries = jobs.entrySet();
        for (Map.Entry<String, Job> entry : entries) {
            String buildId;
            BuildWithDetails buildDetails;
            Build lastBuild;
            String jobName = entry.getKey();
            Job job = entry.getValue();
            String suffix = "";
            JobWithDetails details = job.details();
            if (details != null && (lastBuild = details.getLastBuild()) != null && (buildDetails = lastBuild.details()) != null && (buildId = buildDetails.getId()) != null) {
                suffix = ": #" + buildId;
            }
            System.out.println(indent + jobName + suffix);
            Optional optional = jenkins.getFolderJob(job);
            if (!optional.isPresent()) continue;
            FolderJob folderJob = (FolderJob)optional.get();
            Map children = folderJob.getJobs();
            JenkinsAsserts.displayJobs(jenkins, children, indent + INDENT);
        }
    }

    public static JobWithDetails assertJobPathExists(JenkinsServer jenkins, String ... jobPath) throws IOException {
        JobWithDetails job = JenkinsAsserts.findJobPath(jenkins, jobPath);
        Assert.assertNotNull((String)("Could not find Jenkins Job: " + JenkinsAsserts.fullJobPath(jobPath)), (Object)job);
        LOG.info("Found job " + job.getUrl());
        return job;
    }

    public static QueueReference assertTriggerJobPath(JenkinsServer jenkins, String ... jobPath) throws IOException {
        JobWithDetails jobWithDetails = JenkinsAsserts.assertJobPathExists(jenkins, jobPath);
        QueueReference build = jobWithDetails.build(true);
        Assert.assertNotNull((String)("No build reference for job " + JenkinsAsserts.fullJobPath(jobPath)), (Object)(build != null ? 1 : 0));
        return build;
    }

    public static void assertWaitForNoRunningBuilds(final JenkinsServer jenkins, long timeMillis) throws Exception {
        LOG.info("Waiting for no running Jenkins jobs");
        Asserts.assertWaitFor((long)timeMillis, (Block)new Block(){

            public void invoke() throws Exception {
                List items = jenkins.getQueue().getItems();
                Assert.assertTrue((String)("Waiting for build queue to be empty but has " + items.size()), (boolean)items.isEmpty());
            }
        });
    }

    public static JobWithDetails assertWaitForJobPathExists(final JenkinsServer jenkins, long timeMillis, final String ... jobPath) throws Exception {
        final AtomicReference<Object> holder = new AtomicReference<Object>(null);
        LOG.info("Waiting for Jenkins job " + JenkinsAsserts.fullJobPath(jobPath));
        Asserts.assertWaitFor((long)timeMillis, (Block)new Block(){

            public void invoke() throws Exception {
                holder.set(JenkinsAsserts.assertJobPathExists(jenkins, jobPath));
            }
        });
        return holder.get();
    }

    public static void assertWaitForJobPathNotExist(final JenkinsServer jenkins, long timeMillis, final String ... jobPath) throws Exception {
        final String fullPath = JenkinsAsserts.fullJobPath(jobPath);
        LOG.info("Waiting for Jenkins job to no longer exist " + fullPath);
        Asserts.assertWaitFor((long)timeMillis, (Block)new Block(){

            public void invoke() throws Exception {
                Assert.assertTrue((String)("Jenkins job " + fullPath + " should not exist"), (JenkinsAsserts.findJobPath(jenkins, jobPath) == null ? 1 : 0) != 0);
            }
        });
    }

    public static String fullJobPath(String[] jobPath) {
        return Strings.join((String)"/", (Object[])jobPath);
    }

    public static JobWithDetails findJobPath(JenkinsServer jenkins, String ... jobPath) throws IOException {
        FolderJob folder = null;
        int size = jobPath.length;
        for (int i = 0; i < size; ++i) {
            String path = jobPath[i];
            if (size == 1 && i == 0) {
                return jenkins.getJob(path);
            }
            if (folder == null) {
                JobWithDetails jobDetails = jenkins.getJob(path);
                if (jobDetails == null) {
                    return null;
                }
                Job job = new Job(jobDetails.getName(), jobDetails.getUrl());
                Optional optional = jenkins.getFolderJob(job);
                if (!optional.isPresent()) {
                    return null;
                }
                folder = (FolderJob)optional.get();
                continue;
            }
            Job job = folder.getJob(path);
            if (job == null) {
                return null;
            }
            if (i == size - 1) {
                return job.details();
            }
            Optional optional = jenkins.getFolderJob(job);
            if (!optional.isPresent()) {
                return null;
            }
            folder = (FolderJob)optional.get();
        }
        return null;
    }

    public static Document assertJobXmlDocument(JenkinsServer jenkins, String jobName) {
        String xml;
        JenkinsAsserts.assertJobExists(jenkins, jobName);
        try {
            xml = jenkins.getJobXml(jobName);
        }
        catch (IOException e) {
            throw new AssertionError("Failed to load job XML for " + jobName + " due to " + e, e);
        }
        try {
            return XmlUtils.parseDoc((String)xml);
        }
        catch (Exception e) {
            throw new AssertionError("Failed to load parse XML for " + jobName + " due to " + e, e);
        }
    }
}

